/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.PValueImproverWrapper;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImParams;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.model.SemUpdaterWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.MarshalledObject;
import java.util.List;

public class SemImWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private final SemIm semIm;

    public SemImWrapper(SemEstimatorWrapper semEstWrapper) {
        if (semEstWrapper == null) {
            throw new NullPointerException();
        }
        SemIm oldSemIm = semEstWrapper.getSemEstimator().getEstimatedSem();
        try {
            this.semIm = new MarshalledObject<SemIm>(oldSemIm).get();
        }
        catch (Exception e) {
            throw new RuntimeException("SemIm could not be deep cloned.", e);
        }
        this.log(this.semIm);
    }

    public SemImWrapper(SemPmWrapper semPmWrapper, SemImParams params) {
        if (semPmWrapper == null) {
            throw new NullPointerException("SemPmWrapper must not be null.");
        }
        this.semIm = new SemIm(semPmWrapper.getSemPm(), params.getSemImInitializionParams());
        this.log(this.semIm);
    }

    public SemImWrapper(SemPmWrapper semPmWrapper, SemImWrapper oldSemImWrapper, SemImParams params) {
        if (semPmWrapper == null) {
            throw new NullPointerException("SemPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Params must not be null.");
        }
        SemPm semPm = new SemPm(semPmWrapper.getSemPm());
        SemIm oldSemIm = oldSemImWrapper.getSemIm();
        this.semIm = !params.isRetainPreviousValues() ? new SemIm(semPm, params.getSemImInitializionParams()) : new SemIm(semPm, oldSemIm, params.getSemImInitializionParams());
        this.log(this.semIm);
    }

    public SemImWrapper(SemUpdaterWrapper semUpdaterWrapper) {
        if (semUpdaterWrapper == null) {
            throw new NullPointerException("SemPmWrapper must not be null.");
        }
        this.semIm = new SemIm(semUpdaterWrapper.getSemUpdater().getUpdatedSemIm());
        this.log(this.semIm);
    }

    public SemImWrapper(SemImWrapper semImWrapper) {
        if (semImWrapper == null) {
            throw new NullPointerException("SemPmWrapper must not be null.");
        }
        this.semIm = new SemIm(semImWrapper.getSemIm());
        this.log(this.semIm);
    }

    public SemImWrapper(PValueImproverWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("PValue Improver must not be null.");
        }
        this.semIm = wrapper.getEstSem();
        this.log(this.semIm);
    }

    public static SemImWrapper serializableInstance() {
        return new SemImWrapper(SemPmWrapper.serializableInstance(), new SemImWrapper(SemPmWrapper.serializableInstance(), SemImParams.serializableInstance()), new SemImParams());
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    @Override
    public Graph getGraph() {
        return this.semIm.getSemPm().getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(SemIm im) {
        TetradLogger.getInstance().log("info", "Linear SEM IM");
        TetradLogger.getInstance().log("im", im.toString());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semIm == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

