/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.StandardizedSemIm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class StandardizedSemImWrapper
implements SessionModel,
GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private final StandardizedSemIm standardizedSemIm;
    private boolean showErrors;

    public StandardizedSemImWrapper(SemImWrapper semImWrapper) {
        if (semImWrapper == null) {
            throw new NullPointerException();
        }
        this.standardizedSemIm = new StandardizedSemIm(semImWrapper.getSemIm());
        this.log(this.standardizedSemIm);
    }

    public StandardizedSemImWrapper(SemPmWrapper semPmWrapper) {
        if (semPmWrapper == null) {
            throw new NullPointerException();
        }
        SemIm semIm = new SemIm(semPmWrapper.getSemPm());
        this.standardizedSemIm = new StandardizedSemIm(semIm);
        this.log(this.standardizedSemIm);
    }

    public static StandardizedSemImWrapper serializableInstance() {
        return new StandardizedSemImWrapper(SemImWrapper.serializableInstance());
    }

    public StandardizedSemIm getStandardizedSemIm() {
        return this.standardizedSemIm;
    }

    @Override
    public Graph getGraph() {
        return this.standardizedSemIm.getSemPm().getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.standardizedSemIm == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    private void log(StandardizedSemIm pm) {
        TetradLogger.getInstance().log("info", "Standardized SEM IM");
        TetradLogger.getInstance().log("im", pm.toString());
    }
}

