/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetradapp.model.calculator.expression.Context;
import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.parser.ExpressionParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestExpressionParser
extends TestCase {
    public TestExpressionParser(String name) {
        super(name);
    }

    public void test1() {
        final HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("b11", 1.0);
        values.put("X1", 2.0);
        values.put("X2", 3.0);
        values.put("B22", 4.0);
        values.put("B12", 5.0);
        values.put("X4", 6.0);
        values.put("b13", 7.0);
        values.put("X5", 8.0);
        values.put("b10", 9.0);
        values.put("X", 10.0);
        values.put("Y", 11.0);
        values.put("Z", 12.0);
        values.put("W", 13.0);
        values.put("T", 14.0);
        values.put("R", 15.0);
        Context context = new Context(){

            @Override
            public Double getValue(String var) {
                return (Double)values.get(var);
            }
        };
        HashMap<String, Double> formulasToEvaluations = new HashMap<String, Double>();
        formulasToEvaluations.put("0", 0.0);
        formulasToEvaluations.put("b11*X1 + sin(X2) + B22*X2 + B12*X4+b13*X5", 100.14);
        formulasToEvaluations.put("X5*X4*X4", 288.0);
        formulasToEvaluations.put("sin(b10*X1)", -0.75097);
        formulasToEvaluations.put("((X + ((Y * (Z ^ W)) * T)) + R)", 1.6476953628377112E16);
        formulasToEvaluations.put("X + Y * Z ^ W * T + R", 1.6476953628377112E16);
        formulasToEvaluations.put("pow(2, 5)", 32.0);
        formulasToEvaluations.put("2^5", 32.0);
        formulasToEvaluations.put("exp(1)", 2.718);
        formulasToEvaluations.put("sqrt(2)", 1.414);
        formulasToEvaluations.put("cos(0)", 1.0);
        formulasToEvaluations.put("cos(3.14/2)", 0.0);
        formulasToEvaluations.put("sin(0)", 0.0);
        formulasToEvaluations.put("sin(3.14/2)", 1.0);
        formulasToEvaluations.put("tan(1)", 1.56);
        formulasToEvaluations.put("cosh(1)", 1.54);
        formulasToEvaluations.put("sinh(1)", 1.18);
        formulasToEvaluations.put("tanh(1)", 0.76);
        formulasToEvaluations.put("acos(1)", 0.0);
        formulasToEvaluations.put("asin(1)", 1.57);
        formulasToEvaluations.put("atan(1)", 0.78);
        formulasToEvaluations.put("ln(1)", 0.0);
        formulasToEvaluations.put("log10(10)", 1.0);
        formulasToEvaluations.put("ceil(2.5)", 3.0);
        formulasToEvaluations.put("floor(2.5)", 2.0);
        formulasToEvaluations.put("abs(-5)", 5.0);
        formulasToEvaluations.put("max(2, 5, 3, 1, 10, -3)", 10.0);
        formulasToEvaluations.put("min(2, 5, 3, 1, 10, -3)", -3.0);
        formulasToEvaluations.put("AND(1, 1)", 1.0);
        formulasToEvaluations.put("AND(1, 0)", 0.0);
        formulasToEvaluations.put("AND(0, 1)", 0.0);
        formulasToEvaluations.put("AND(0, 0)", 0.0);
        formulasToEvaluations.put("AND(0, 0.5)", 0.0);
        formulasToEvaluations.put("1 AND 1", 1.0);
        formulasToEvaluations.put("OR(1, 1)", 1.0);
        formulasToEvaluations.put("OR(1, 0)", 1.0);
        formulasToEvaluations.put("OR(0, 1)", 1.0);
        formulasToEvaluations.put("OR(0, 0)", 0.0);
        formulasToEvaluations.put("OR(0, 0.5)", 0.0);
        formulasToEvaluations.put("1 OR 1", 1.0);
        formulasToEvaluations.put("XOR(1, 1)", 0.0);
        formulasToEvaluations.put("XOR(1, 0)", 1.0);
        formulasToEvaluations.put("XOR(0, 1)", 1.0);
        formulasToEvaluations.put("XOR(0, 0)", 0.0);
        formulasToEvaluations.put("XOR(0, 0.5)", 0.0);
        formulasToEvaluations.put("1 XOR 1", 0.0);
        formulasToEvaluations.put("1 AND 0 OR 1 XOR 1 + 1", 1.0);
        formulasToEvaluations.put("1 < 2", 1.0);
        formulasToEvaluations.put("1 < 0", 0.0);
        formulasToEvaluations.put("1 < 1", 0.0);
        formulasToEvaluations.put("1 <= 2", 1.0);
        formulasToEvaluations.put("1 <= 1", 1.0);
        formulasToEvaluations.put("1 <= -1", 0.0);
        formulasToEvaluations.put("1 = 2", 0.0);
        formulasToEvaluations.put("1 = 1", 1.0);
        formulasToEvaluations.put("1 = -1", 0.0);
        formulasToEvaluations.put("1 > 2", 0.0);
        formulasToEvaluations.put("1 > 1", 0.0);
        formulasToEvaluations.put("1 > -1", 1.0);
        formulasToEvaluations.put("1 >= 2", 0.0);
        formulasToEvaluations.put("1 >= 1", 1.0);
        formulasToEvaluations.put("1 >= -1", 1.0);
        formulasToEvaluations.put("IF(1 > 2, 1, 2)", 2.0);
        formulasToEvaluations.put("IF(1 < 2, 1, 2)", 1.0);
        formulasToEvaluations.put("IF(1 < 2 AND 3 < 4, 1, 2)", 1.0);
        ExpressionParser parser = new ExpressionParser();
        try {
            for (String formula : formulasToEvaluations.keySet()) {
                Expression expression = parser.parseExpression(formula);
                System.out.println(expression);
                double value = expression.evaluate(context);
                TestExpressionParser.assertEquals((Double)formulasToEvaluations.get(formula), value, 0.01);
                System.out.println(value);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void test2() {
        final HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("b11", 1.0);
        values.put("X1", 2.0);
        values.put("X2", 3.0);
        values.put("B22", 4.0);
        values.put("B12", 5.0);
        values.put("X4", 6.0);
        values.put("b13", 7.0);
        values.put("X5", 8.0);
        values.put("b10", 9.0);
        values.put("X", 10.0);
        values.put("Y", 11.0);
        values.put("Z", 12.0);
        values.put("W", 13.0);
        values.put("T", 14.0);
        values.put("R", 15.0);
        values.put("s2", 0.0);
        values.put("s3", 1.0);
        Context context = new Context(){

            @Override
            public Double getValue(String var) {
                return (Double)values.get(var);
            }
        };
        ArrayList<String> formulas = new ArrayList<String>();
        formulas.add("ChiSquare(s3)");
        formulas.add("Gamma(1, 1)");
        formulas.add("Beta(3, 5)");
        formulas.add("Poisson(5)");
        formulas.add("Indicator(0.3)");
        formulas.add("ExponentialPower(3)");
        formulas.add("exp(Normal(s2, s3))");
        formulas.add("Normal(0, s3)");
        formulas.add("abs(Normal(s2, s3) ^ 3)");
        formulas.add("Discrete(3, 1, 5)");
        formulas.add("0.3 * Normal(-2.0e2, 0.5) + 0.7 * Normal(2.0, 0.5)");
        formulas.add("StudentT(s3)");
        formulas.add("s3");
        formulas.add("Hyperbolic(5, 3)");
        formulas.add("Uniform(s2, s3)");
        formulas.add("VonMises(s3)");
        formulas.add("Split(0, 1, 5, 6)");
        formulas.add("Mixture(0.5, N(-2, 0.5), 0.5, N(2, 0.5))");
        ExpressionParser parser = new ExpressionParser();
        try {
            for (String formula : formulas) {
                Expression expression = parser.parseExpression(formula);
                System.out.println(expression);
                double value = expression.evaluate(context);
                System.out.println(value);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void test3() {
        String regex1 = "[0-9]+((\\.?)[0-9]+)?";
        String regex2 = "[0-9]+(\\.?)[0-9]*";
        String regex3 = "(\\.?)[0-9]+";
        String regex4 = "[0-9]+(\\.?)";
        String regex5 = "([0-9]+)|([0-9]+\\.?[0-9]*)|([0-9]*\\.?[0-9]+)";
        String regex6 = "(-?[0-9]+\\.[0-9]*)|(-?[0-9]*\\.[0-9]+)|(-?[0-9]+)";
        String regex = regex6;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher("0.5");
        boolean matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(matches);
        matcher = pattern.matcher(".5");
        matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(matches);
        matcher = pattern.matcher("5.");
        matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(matches);
        matcher = pattern.matcher("5");
        matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(matches);
        matcher = pattern.matcher(".");
        matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(!matches);
        matcher = pattern.matcher("-.5");
        matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(matches);
        matcher = pattern.matcher("-5.");
        matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(matches);
        matcher = pattern.matcher("-5");
        matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(matches);
        matcher = pattern.matcher("-.");
        matches = matcher.matches();
        if (matches) {
            System.out.println(matcher.group());
        }
        TestExpressionParser.assertTrue(!matches);
    }

    public void test4() {
        LinkedHashMap<String, Integer> formulasToOffsets = new LinkedHashMap<String, Integer>();
        formulasToOffsets.put("X X", 2);
        formulasToOffsets.put("b11 b11", 4);
        formulasToOffsets.put("X + Y ++", 7);
        formulasToOffsets.put("b1*X1 *+ b2 * X2 +", 17);
        formulasToOffsets.put("cos()", 0);
        formulasToOffsets.put("2..3 * X", 0);
        formulasToOffsets.put("+X1", -1);
        formulasToOffsets.put("-X1", -1);
        formulasToOffsets.put("A / B", -1);
        formulasToOffsets.put("b1*X1 +@**!! b2 * X2", 7);
        formulasToOffsets.put("X7", 0);
        ArrayList<String> otherNodes = new ArrayList<String>();
        otherNodes.add("X7");
        ExpressionParser parser = new ExpressionParser(otherNodes, ExpressionParser.RestrictionType.MAY_NOT_CONTAIN);
        for (String formula : formulasToOffsets.keySet()) {
            try {
                System.out.println(formula);
                parser.parseExpression(formula);
                TestExpressionParser.assertEquals((Integer)formulasToOffsets.get(formula), -1);
            }
            catch (ParseException e) {
                int offset = e.getErrorOffset();
                for (int i = 0; i < offset; ++i) {
                    System.out.print(" ");
                }
                System.out.println("^");
                System.out.println("offset = " + offset);
                System.out.println();
                TestExpressionParser.assertEquals((Integer)formulasToOffsets.get(formula), offset);
            }
        }
    }

    public void test5() {
        final HashMap values = new HashMap();
        Context context = new Context(){

            @Override
            public Double getValue(String var) {
                return (Double)values.get(var);
            }
        };
        LinkedHashMap<String, Double> formulas = new LinkedHashMap<String, Double>();
        formulas.put("ChiSquare(1)", 1.0);
        formulas.put("Gamma(1, 3)", 0.33);
        formulas.put("Beta(1, 2)", 0.33);
        formulas.put("Poisson(5)", 5.0);
        formulas.put("ExponentialPower(3)", 0.001);
        formulas.put("Normal(2, 3)", 2.0);
        formulas.put("N(2, 3)", 2.0);
        formulas.put("StudentT(5)", 0.0);
        formulas.put("Hyperbolic(5, 3)", 1.04);
        formulas.put("U(0, 1)", 0.5);
        formulas.put("Uniform(0, 1)", 0.5);
        formulas.put("Split(0, 1, 5, 6)", 3.0);
        formulas.put("VonMises(1)", 0.0);
        ExpressionParser parser = new ExpressionParser();
        try {
            for (String formula : formulas.keySet()) {
                Expression expression = parser.parseExpression(formula);
                System.out.println(expression);
                double sum = 0.0;
                int sampleSize = 10000;
                for (int i = 0; i < sampleSize; ++i) {
                    double value = expression.evaluate(context);
                    sum += value;
                }
                double mean = sum / (double)sampleSize;
                TestExpressionParser.assertEquals((Double)formulas.get(formula), mean, 0.1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void test6() {
        try {
            System.out.println(RandomUtil.getInstance().nextNormal(5.0, -1.0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static Test suite() {
        return new TestSuite(TestExpressionParser.class);
    }
}

