/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator.expression;

import edu.cmu.tetradapp.model.calculator.expression.Context;
import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionDescriptor;
import java.util.Collections;
import java.util.List;

public class ConstantExpression
implements Expression {
    static final long serialVersionUID = 23L;
    public static final ConstantExpression PI = new ConstantExpression(Math.PI, "PI");
    public static final ConstantExpression E = new ConstantExpression(Math.E, "E");
    private double value;
    private String name;

    public ConstantExpression(double value) {
        this.value = value;
    }

    public ConstantExpression(double value, String name) {
        if (name == null) {
            throw new NullPointerException("name was null.");
        }
        this.value = value;
        this.name = name;
    }

    public static ConstantExpression serializableInstance() {
        return new ConstantExpression(1.2);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public double evaluate(Context context) {
        return this.value;
    }

    @Override
    public String getToken() {
        return "";
    }

    @Override
    public ExpressionDescriptor.Position getPosition() {
        return ExpressionDescriptor.Position.NEITHER;
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.emptyList();
    }

    public String toString() {
        if (this.name == null) {
            return Double.toString(this.value);
        }
        return this.name;
    }
}

