/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.calculator.expression;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetradapp.model.calculator.expression.AbstractExpression;
import edu.cmu.tetradapp.model.calculator.expression.AbstractExpressionDescriptor;
import edu.cmu.tetradapp.model.calculator.expression.Context;
import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionDescriptor;
import edu.cmu.tetradapp.model.calculator.expression.ExpressionInitializationException;
import edu.cmu.tetradapp.model.calculator.expression.VariableExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExpressionManager {
    private Map<String, ExpressionDescriptor> tokenMap = new HashMap<String, ExpressionDescriptor>();
    private List<ExpressionDescriptor> descriptors = new ArrayList<ExpressionDescriptor>(ExpressionManager.listDescriptors());
    private static final ExpressionManager INSTANCE = new ExpressionManager();

    private ExpressionManager() {
        for (ExpressionDescriptor exp : this.descriptors) {
            if (this.tokenMap.containsKey(exp.getToken())) {
                throw new IllegalStateException("Expression descriptors must have unique tokens, but " + exp.getToken() + " is not unique.");
            }
            this.tokenMap.put(exp.getToken(), exp);
        }
    }

    public static ExpressionManager getInstance() {
        return INSTANCE;
    }

    public List<ExpressionDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    public ExpressionDescriptor getDescriptorFromToken(String token) {
        return this.tokenMap.get(token);
    }

    private static List<ExpressionDescriptor> listDescriptors() {
        LinkedList<ExpressionDescriptor> descriptors = new LinkedList<ExpressionDescriptor>();
        descriptors.add(new NewExpressionDescriptor());
        descriptors.add(new TSumExpressionDescriptor());
        descriptors.add(new TProductExpressionDescriptor());
        descriptors.add(new AdditionExpressionDescriptor());
        descriptors.add(new SubtractionExpressionDescriptor());
        descriptors.add(new MultiplicationExpressionDescriptor());
        descriptors.add(new DivisionExpressionDescriptor());
        descriptors.add(new PowExpressionDescriptor());
        descriptors.add(new PowExpressionDescriptor2());
        descriptors.add(new ExpExpressionDescriptor());
        descriptors.add(new SquareRootExpressionDescriptor());
        descriptors.add(new CoshExpressionDescriptor());
        descriptors.add(new SinhExpressionDescriptor());
        descriptors.add(new TanhExpressionDescriptor());
        descriptors.add(new CosExpressionDescriptor());
        descriptors.add(new SinExpressionDescriptor());
        descriptors.add(new TanExpressionDescriptor());
        descriptors.add(new AcosExpressionDescriptor());
        descriptors.add(new AsinExpressionDescriptor());
        descriptors.add(new AtanExpressionDescriptor());
        descriptors.add(new NaturalLogExpressionDescriptor());
        descriptors.add(new Log10ExpressionDescriptor());
        descriptors.add(new RoundExpressionDescriptor());
        descriptors.add(new CeilExpressionDescriptor());
        descriptors.add(new FloorExpressionDescriptor());
        descriptors.add(new AbsoluteValueExpressionDescriptor());
        descriptors.add(new RandomExpressionDescriptor());
        descriptors.add(new MaxExpressionDescriptor());
        descriptors.add(new MinExpressionDescriptor());
        descriptors.add(new AndExpressionDescriptor());
        descriptors.add(new OrExpressionDescriptor());
        descriptors.add(new XOrExpressionDescriptor());
        descriptors.add(new LessThanOrEqualExpressionDescriptor());
        descriptors.add(new LessThanExpressionDescriptor());
        descriptors.add(new EqualsExpressionDescriptor());
        descriptors.add(new GreaterThanOrEqualExpressionDescriptor());
        descriptors.add(new GreaterThanExpressionDescriptor());
        descriptors.add(new IfExpressionDescriptor());
        descriptors.add(new ChiSquareExpressionDescriptor());
        descriptors.add(new GammaExpressionDescriptor());
        descriptors.add(new BetaExpressionDescriptor());
        descriptors.add(new PoissonExpressionDescriptor());
        descriptors.add(new IndicatorExpressionDescriptor());
        descriptors.add(new ExponentialPowerExpressionDescriptor());
        descriptors.add(new ExponentialExpressionDescriptor());
        descriptors.add(new NormalExpressionDescriptor());
        descriptors.add(new NExpressionDescriptor());
        descriptors.add(new DiscreteExpressionDescriptor());
        descriptors.add(new MixtureDescriptor());
        descriptors.add(new StudentTExpressionDescriptor());
        descriptors.add(new HyperbolicExpressionDescriptor());
        descriptors.add(new UniformExpressionDescriptor());
        descriptors.add(new UExpressionDescriptor());
        descriptors.add(new SplitExpressionDescriptor());
        descriptors.add(new VonMisesExpressionDescriptor());
        return descriptors;
    }

    private static class TProductExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public TProductExpressionDescriptor() {
            super("Template Product", "TPROD", ExpressionDescriptor.Position.PREFIX, true, true, false, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Must have one argument, a parameter.");
            }
            return new AbstractExpression("TPROD", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return Double.NaN;
                }
            };
        }
    }

    private static class TSumExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public TSumExpressionDescriptor() {
            super("Template Sum", "TSUM", ExpressionDescriptor.Position.PREFIX, true, true, false, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Must have one argument, a parameter.");
            }
            return new AbstractExpression("TSUM", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return Double.NaN;
                }
            };
        }
    }

    private static class NewExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public NewExpressionDescriptor() {
            super("New Parameter", "NEW", ExpressionDescriptor.Position.PREFIX, true, true, false, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Must have one argument, a parameter.");
            }
            if (!(expressions[0] instanceof VariableExpression)) {
                throw new ExpressionInitializationException("Expecting a parameter name as argument.");
            }
            return new AbstractExpression("NEW", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return Double.NaN;
                }
            };
        }
    }

    private static class IfExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public IfExpressionDescriptor() {
            super("If", "IF", ExpressionDescriptor.Position.PREFIX, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 3) {
                throw new ExpressionInitializationException("Must have three arguments.");
            }
            return new AbstractExpression("IF", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    List<Expression> expressions = this.getExpressions();
                    double a = expressions.get(0).evaluate(context);
                    double b = expressions.get(1).evaluate(context);
                    double c = expressions.get(2).evaluate(context);
                    return a == 1.0 ? b : c;
                }
            };
        }
    }

    private static class GreaterThanOrEqualExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public GreaterThanOrEqualExpressionDescriptor() {
            super("Greater Than Or Equal", ">=", ExpressionDescriptor.Position.BOTH, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Must have two arguments.");
            }
            return new AbstractExpression("<", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double b;
                    List<Expression> expressions = this.getExpressions();
                    double a = expressions.get(0).evaluate(context);
                    return a >= (b = expressions.get(1).evaluate(context)) ? 1.0 : 0.0;
                }
            };
        }
    }

    private static class GreaterThanExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public GreaterThanExpressionDescriptor() {
            super("Greater Than", ">", ExpressionDescriptor.Position.BOTH, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Must have two arguments.");
            }
            return new AbstractExpression("<", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double b;
                    List<Expression> expressions = this.getExpressions();
                    double a = expressions.get(0).evaluate(context);
                    return a > (b = expressions.get(1).evaluate(context)) ? 1.0 : 0.0;
                }
            };
        }
    }

    private static class EqualsExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public EqualsExpressionDescriptor() {
            super("Equals", "=", ExpressionDescriptor.Position.BOTH, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Must have two arguments.");
            }
            return new AbstractExpression("=", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double b;
                    List<Expression> expressions = this.getExpressions();
                    double a = expressions.get(0).evaluate(context);
                    return a == (b = expressions.get(1).evaluate(context)) ? 1.0 : 0.0;
                }
            };
        }
    }

    private static class LessThanOrEqualExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public LessThanOrEqualExpressionDescriptor() {
            super("Less Than Or Equal", "<=", ExpressionDescriptor.Position.BOTH, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Must have two arguments.");
            }
            return new AbstractExpression("<=", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double b;
                    List<Expression> expressions = this.getExpressions();
                    double a = expressions.get(0).evaluate(context);
                    return a <= (b = expressions.get(1).evaluate(context)) ? 1.0 : 0.0;
                }
            };
        }
    }

    private static class LessThanExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public LessThanExpressionDescriptor() {
            super("Less Than", "<", ExpressionDescriptor.Position.BOTH, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Must have two arguments.");
            }
            return new AbstractExpression("<", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double b;
                    List<Expression> expressions = this.getExpressions();
                    double a = expressions.get(0).evaluate(context);
                    return a < (b = expressions.get(1).evaluate(context)) ? 1.0 : 0.0;
                }
            };
        }
    }

    private static class XOrExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public XOrExpressionDescriptor() {
            super("Exclusive or", "XOR", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr", "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Must have two arguments.");
            }
            return new AbstractExpression("XOR", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double first = this.getExpressions().get(0).evaluate(context);
                    double second = this.getExpressions().get(1).evaluate(context);
                    first = first == 1.0 ? 1.0 : 0.0;
                    second = second == 1.0 ? 1.0 : 0.0;
                    return first + second == 1.0 ? 1.0 : 0.0;
                }
            };
        }
    }

    private static class OrExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public OrExpressionDescriptor() {
            super("Or", "OR", ExpressionDescriptor.Position.PREFIX, false, true, true, "expr", "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length < 2) {
                throw new ExpressionInitializationException("Must have at least two arguments.");
            }
            return new AbstractExpression("OR", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    for (Expression exp : this.getExpressions()) {
                        if (exp.evaluate(context) != 1.0) continue;
                        return 1.0;
                    }
                    return 0.0;
                }
            };
        }
    }

    private static class AndExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public AndExpressionDescriptor() {
            super("And", "AND", ExpressionDescriptor.Position.PREFIX, false, true, true, "expr", "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length < 2) {
                throw new ExpressionInitializationException("Must have at least two arguments.");
            }
            return new AbstractExpression("AND", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    boolean allOnes = true;
                    for (Expression exp : this.getExpressions()) {
                        if (exp.evaluate(context) == 1.0) continue;
                        allOnes = false;
                    }
                    return allOnes ? 1.0 : 0.0;
                }
            };
        }
    }

    private static class VonMisesExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public VonMisesExpressionDescriptor() {
            super("VonMises", "VonMises", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("VonMises must have one argument.");
            }
            return new AbstractExpression("VonMises", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    return RandomUtil.getInstance().nextVonMises(exp1.evaluate(context));
                }
            };
        }
    }

    private static class SplitExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public SplitExpressionDescriptor() {
            super("Split", "Split", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length % 2 != 0) {
                throw new ExpressionInitializationException("Split must have two arguments.");
            }
            return new AbstractExpression("Split", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    if (this.getExpressions().size() < 2) {
                        throw new IllegalArgumentException("Split must have at least two arguments, Split(a, b).");
                    }
                    double[] endpoints = new double[this.getExpressions().size()];
                    for (int i = 0; i < this.getExpressions().size(); ++i) {
                        endpoints[i] = this.getExpressions().get(i).evaluate(context);
                    }
                    double[] lengths = new double[endpoints.length / 2];
                    double totalLength = 0.0;
                    for (int i = 0; i < endpoints.length / 2; ++i) {
                        if (endpoints[2 * i] >= endpoints[2 * i + 1]) {
                            throw new IllegalArgumentException("For Split, a must be less than be for each pair.");
                        }
                        lengths[i] = endpoints[2 * i + 1] - endpoints[2 * i];
                        totalLength += lengths[i];
                    }
                    double r = RandomUtil.getInstance().nextDouble() * totalLength;
                    for (int i = 0; i < endpoints.length / 2; ++i) {
                        if (r < lengths[i]) {
                            return endpoints[2 * i] + r;
                        }
                        r -= lengths[i];
                    }
                    return Double.NaN;
                }
            };
        }
    }

    private static class UniformExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public UniformExpressionDescriptor() {
            super("Uniform", "Uniform", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Uniform must have two arguments.");
            }
            return new AbstractExpression("Uniform", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double b;
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    double a = exp1.evaluate(context);
                    if (a >= (b = exp2.evaluate(context))) {
                        return Double.NaN;
                    }
                    return RandomUtil.getInstance().nextUniform(a, b);
                }
            };
        }
    }

    private static class UExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public UExpressionDescriptor() {
            super("Uniform", "U", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Uniform must have two arguments.");
            }
            return new AbstractExpression("U", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double b;
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    double a = exp1.evaluate(context);
                    if (a >= (b = exp2.evaluate(context))) {
                        return Double.NaN;
                    }
                    return RandomUtil.getInstance().nextUniform(a, b);
                }
            };
        }
    }

    private static class HyperbolicExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public HyperbolicExpressionDescriptor() {
            super("Hyperbolic", "Hyperbolic", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Hyperbolic must have two arguments.");
            }
            return new AbstractExpression("Hyperbolic", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    return RandomUtil.getInstance().nextHyperbolic(exp1.evaluate(context), exp2.evaluate(context));
                }
            };
        }
    }

    private static class SingleValueExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public SingleValueExpressionDescriptor() {
            super("Single Value", "SingleValue", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("SingleValue must have one argument.");
            }
            return new AbstractExpression("SingleValue", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    return exp1.evaluate(context);
                }
            };
        }
    }

    private static class StudentTExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public StudentTExpressionDescriptor() {
            super("Student T", "StudentT", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("StudentT must have one argument.");
            }
            return new AbstractExpression("StudentT", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    return RandomUtil.getInstance().nextStudentT(exp1.evaluate(context));
                }
            };
        }
    }

    private static class MixtureDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public MixtureDescriptor() {
            super("Mixture", "Mixture", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length <= 0 || expressions.length % 2 != 0) {
                throw new ExpressionInitializationException("Mixture must have an even expr of arguments, 2 or more.");
            }
            return new AbstractExpression("Mixture", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    int i;
                    List<Expression> exp = this.getExpressions();
                    int numMixed = exp.size() / 2;
                    double[] a = new double[numMixed];
                    double totalA = 0.0;
                    for (i = 0; i < numMixed; ++i) {
                        a[i] = exp.get(2 * i).evaluate(context);
                        if (a[i] <= 0.0) {
                            throw new IllegalArgumentException("Coefficients must be > 0: " + a[i]);
                        }
                        totalA += a[i];
                    }
                    if (Math.abs(totalA - 1.0) > 0.01) {
                        throw new IllegalArgumentException("Coefficients must sum to 1.0: " + totalA);
                    }
                    i = 0;
                    while (i < numMixed) {
                        int n = i++;
                        a[n] = a[n] / totalA;
                    }
                    double r = RandomUtil.getInstance().nextDouble();
                    double sum = 0.0;
                    for (int i2 = 0; i2 < numMixed; ++i2) {
                        if (!(r < (sum += a[i2]))) continue;
                        System.out.println("a[" + i2 + "] = " + a[i2] + " sum = " + sum);
                        return exp.get(2 * i2 + 1).evaluate(context);
                    }
                    throw new IllegalStateException("Random expr did not choose one of the options: " + r);
                }
            };
        }
    }

    private static class DiscreteExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public DiscreteExpressionDescriptor() {
            super("Discrete", "Discrete", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length < 1) {
                throw new ExpressionInitializationException("Discrete distribution must have at least one argument.");
            }
            return new AbstractExpression("Discrete", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double[] p = new double[this.getExpressions().size()];
                    for (int i = 0; i < this.getExpressions().size(); ++i) {
                        Expression exp = this.getExpressions().get(i);
                        p[i] = exp.evaluate(context);
                    }
                    p = this.convert(p);
                    double r = RandomUtil.getInstance().nextDouble();
                    for (int i = 0; i < p.length; ++i) {
                        if (!(r < p[i])) continue;
                        return i;
                    }
                    throw new IllegalArgumentException();
                }

                private double[] convert(double ... p) {
                    int i;
                    for (double _p : p) {
                        if (!(_p < 0.0)) continue;
                        throw new IllegalArgumentException("All arguments must be >= 0: " + _p);
                    }
                    double sum = 0.0;
                    for (double _p : p) {
                        sum += _p;
                    }
                    for (i = 0; i < p.length; ++i) {
                        int n = i;
                        double d = p[n] / sum;
                        p[n] = d;
                        p[i] = d;
                    }
                    for (i = 1; i < p.length; ++i) {
                        p[i] = p[i - 1] + p[i];
                    }
                    return p;
                }
            };
        }
    }

    private static class GaussianPowerExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public GaussianPowerExpressionDescriptor() {
            super("GaussianPower", "GaussianPower", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Exp must have one argument.");
            }
            return new AbstractExpression("GaussianPower", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    double power = exp1.evaluate(context);
                    double value = RandomUtil.getInstance().nextNormal(0.0, 1.0);
                    double poweredValue = Math.pow(Math.abs(value), power);
                    return value >= 0.0 ? poweredValue : -poweredValue;
                }
            };
        }
    }

    private static class NExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public NExpressionDescriptor() {
            super("Normal", "N", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Normal must have two arguments.");
            }
            return new AbstractExpression("N", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    double mean = exp1.evaluate(context);
                    double sd = exp2.evaluate(context);
                    if (sd < 0.0) {
                        return Double.NaN;
                    }
                    return RandomUtil.getInstance().nextNormal(mean, sd);
                }
            };
        }
    }

    private static class NormalExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public NormalExpressionDescriptor() {
            super("Normal", "Normal", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Normal must have two arguments.");
            }
            return new AbstractExpression("Normal", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    double mean = exp1.evaluate(context);
                    double sd = exp2.evaluate(context);
                    if (sd < 0.0) {
                        return Double.NaN;
                    }
                    return RandomUtil.getInstance().nextNormal(mean, sd);
                }
            };
        }
    }

    private static class LogNormalExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public LogNormalExpressionDescriptor() {
            super("Log Normal", "LogNormal", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Exp must have one argument.");
            }
            return new AbstractExpression("LogNormal", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    double sd = exp1.evaluate(context);
                    double random = RandomUtil.getInstance().nextNormal(0.0, sd);
                    return Math.exp(random);
                }
            };
        }
    }

    private static class ExponentialExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public ExponentialExpressionDescriptor() {
            super("Exponential", "Exponential", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Exp must have one argument.");
            }
            return new AbstractExpression("ExponentialPower", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    return RandomUtil.getInstance().nextExponential(exp1.evaluate(context));
                }
            };
        }
    }

    private static class ExponentialPowerExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public ExponentialPowerExpressionDescriptor() {
            super("ExponentialPower", "ExponentialPower", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Exp must have one argument.");
            }
            return new AbstractExpression("ExponentialPower", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    return RandomUtil.getInstance().nextExponentialPower(exp1.evaluate(context));
                }
            };
        }
    }

    private static class IndicatorExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public IndicatorExpressionDescriptor() {
            super("Indicator", "Indicator", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Exp must have one argument.");
            }
            return new AbstractExpression("Indicator", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    double p = exp1.evaluate(context);
                    if (p < 0.0 || p > 1.0) {
                        throw new IllegalArgumentException("p must be in [0, 1].");
                    }
                    return RandomUtil.getInstance().nextDouble() < p ? 1.0 : 0.0;
                }
            };
        }
    }

    private static class PoissonExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public PoissonExpressionDescriptor() {
            super("Poisson", "Poisson", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Poisson must have one argument.");
            }
            return new AbstractExpression("Poisson", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    return RandomUtil.getInstance().nextPoisson(exp1.evaluate(context));
                }
            };
        }
    }

    private static class BetaExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public BetaExpressionDescriptor() {
            super("Beta", "Beta", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Beta must have one argument.");
            }
            return new AbstractExpression("Beta", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    return RandomUtil.getInstance().nextBeta(exp1.evaluate(context), exp2.evaluate(context));
                }
            };
        }
    }

    private static class GammaExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public GammaExpressionDescriptor() {
            super("Gamma", "Gamma", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Gamma must have two arguments.");
            }
            return new AbstractExpression("Gamma", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    return RandomUtil.getInstance().nextGamma(exp1.evaluate(context), exp2.evaluate(context));
                }
            };
        }
    }

    private static class ChiSquareExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public ChiSquareExpressionDescriptor() {
            super("Chi Square", "ChiSquare", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("ChiSquare must have one argument.");
            }
            return new AbstractExpression("ChiSquare", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    return RandomUtil.getInstance().nextChiSquare(exp1.evaluate(context));
                }
            };
        }
    }

    private static class MinExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public MinExpressionDescriptor() {
            super("Minimum", "min", ExpressionDescriptor.Position.PREFIX, false, true, true, "expr", "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length < 2) {
                throw new ExpressionInitializationException("min must have two or more arguments.");
            }
            return new AbstractExpression("min", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double min = this.getExpressions().get(0).evaluate(context);
                    for (int i = 1; i < this.getExpressions().size(); ++i) {
                        double d = this.getExpressions().get(i).evaluate(context);
                        if (!(d < min)) continue;
                        min = d;
                    }
                    return min;
                }
            };
        }
    }

    private static class MaxExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public MaxExpressionDescriptor() {
            super("Maximum", "max", ExpressionDescriptor.Position.PREFIX, false, true, true, "expr", "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length < 2) {
                throw new ExpressionInitializationException("max must have two or more arguments.");
            }
            return new AbstractExpression("max", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double max = this.getExpressions().get(0).evaluate(context);
                    for (int i = 1; i < this.getExpressions().size(); ++i) {
                        double d = this.getExpressions().get(i).evaluate(context);
                        if (!(max < d)) continue;
                        max = d;
                    }
                    return max;
                }
            };
        }
    }

    private static class ExpExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public ExpExpressionDescriptor() {
            super("Exponential", "exp", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Exp must have one argument.");
            }
            return new AbstractExpression("exp", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    return StrictMath.exp(exp1.evaluate(context));
                }
            };
        }
    }

    private static class PowExpressionDescriptor2
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public PowExpressionDescriptor2() {
            super("Power", "^", ExpressionDescriptor.Position.INFIX, false, false, true, "expr", "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Pow must have two arguments.");
            }
            return new AbstractExpression("^", ExpressionDescriptor.Position.INFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    return StrictMath.pow(exp1.evaluate(context), exp2.evaluate(context));
                }
            };
        }
    }

    private static class PowExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public PowExpressionDescriptor() {
            super("Power", "pow", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr", "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Pow must have two arguments.");
            }
            return new AbstractExpression("pow", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    Expression exp1 = this.getExpressions().get(0);
                    Expression exp2 = this.getExpressions().get(1);
                    return StrictMath.pow(exp1.evaluate(context), exp2.evaluate(context));
                }
            };
        }
    }

    private static class AsinExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public AsinExpressionDescriptor() {
            super("Arc Sine", "asin", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Asin must have one and only one argument.");
            }
            return new AbstractExpression("asin", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.asin(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class SinhExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public SinhExpressionDescriptor() {
            super("Sinh", "sinh", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Sinh must have one and only one argument.");
            }
            return new AbstractExpression("sinh", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.sinh(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class SinExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public SinExpressionDescriptor() {
            super("Sine", "sin", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Sine must have one and only one argument.");
            }
            return new AbstractExpression("sin", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.sin(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class SquareRootExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public SquareRootExpressionDescriptor() {
            super("Square Root", "sqrt", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Square Root must have one and only one argument.");
            }
            return new AbstractExpression("sqrt", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.sqrt(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class AtanExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public AtanExpressionDescriptor() {
            super("Arc Tangent", "atan", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Atan must have one and only one argument.");
            }
            return new AbstractExpression("atan", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.atan(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class TanhExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public TanhExpressionDescriptor() {
            super("Hyperbolic tangent", "tanh", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Hyperbolic tangent must have one and only one argument.");
            }
            return new AbstractExpression("tanh", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.tanh(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class TanExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public TanExpressionDescriptor() {
            super("Tangent", "tan", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Tan must have one and only one argument.");
            }
            return new AbstractExpression("tan", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.tan(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class RoundExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public RoundExpressionDescriptor() {
            super("Round", "round", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Round must have one and only one argument.");
            }
            return new AbstractExpression("round", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.round(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class RandomExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public RandomExpressionDescriptor() {
            super("Random", "random", ExpressionDescriptor.Position.PREFIX, false, false, false, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 0) {
                throw new ExpressionInitializationException("Random must have no arguments.");
            }
            return new AbstractExpression("random", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.random();
                }
            };
        }
    }

    private static class NaturalLogExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public NaturalLogExpressionDescriptor() {
            super("Log base e", "ln", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("log must have one and only one argument.");
            }
            return new AbstractExpression("ln", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.log(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class DivisionExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public DivisionExpressionDescriptor() {
            super("Division", "/", ExpressionDescriptor.Position.BOTH, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 2) {
                throw new ExpressionInitializationException("Must have two arguments.");
            }
            return new AbstractExpression("/", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return this.getExpressions().get(0).evaluate(context) / this.getExpressions().get(1).evaluate(context);
                }
            };
        }
    }

    private static class MultiplicationExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public MultiplicationExpressionDescriptor() {
            super("Multiplication", "*", ExpressionDescriptor.Position.BOTH, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length < 2) {
                throw new ExpressionInitializationException("Must have at least two arguments.");
            }
            return new AbstractExpression("*", ExpressionDescriptor.Position.BOTH, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    double value = 1.0;
                    for (Expression exp : this.getExpressions()) {
                        value *= exp.evaluate(context);
                    }
                    return value;
                }
            };
        }
    }

    private static class Log10ExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public Log10ExpressionDescriptor() {
            super("Log base 10", "log10", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Log10 must have one and only one argument.");
            }
            return new AbstractExpression("log10", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.log10(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class AbsoluteValueExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public AbsoluteValueExpressionDescriptor() {
            super("Abs", "abs", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Floor must have one and only one argument.");
            }
            return new AbstractExpression("abs", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.abs(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class FloorExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public FloorExpressionDescriptor() {
            super("Floor", "floor", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Floor must have one and only one argument.");
            }
            return new AbstractExpression("floor", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.floor(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class AcosExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public AcosExpressionDescriptor() {
            super("Arc Cosine", "acos", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Acos must have one and only one argument.");
            }
            return new AbstractExpression("acos", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.acos(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class CoshExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public CoshExpressionDescriptor() {
            super("Hyperbolic Cosine", "cosh", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Cosh must have one and only one argument.");
            }
            return new AbstractExpression("cosh", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.cosh(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class CosExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public CosExpressionDescriptor() {
            super("Cosine", "cos", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Cos must have one and only one argument.");
            }
            return new AbstractExpression("cos", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.cos(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class CeilExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public CeilExpressionDescriptor() {
            super("Ceil", "ceil", ExpressionDescriptor.Position.PREFIX, false, false, true, "expr");
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length != 1) {
                throw new ExpressionInitializationException("Ceil must have one and only one argument.");
            }
            return new AbstractExpression("ceil", ExpressionDescriptor.Position.PREFIX, expressions){
                static final long serialVersionUID = 23L;

                @Override
                public double evaluate(Context context) {
                    return StrictMath.ceil(this.getExpressions().get(0).evaluate(context));
                }
            };
        }
    }

    private static class SubtractionExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public SubtractionExpressionDescriptor() {
            super("Subtraction", "-", ExpressionDescriptor.Position.INFIX, false, false, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length == 1) {
                return new AbstractExpression("-", ExpressionDescriptor.Position.INFIX, expressions){
                    static final long serialVersionUID = 23L;

                    @Override
                    public double evaluate(Context context) {
                        return -this.getExpressions().get(0).evaluate(context);
                    }
                };
            }
            if (expressions.length == 2) {
                return new AbstractExpression("-", ExpressionDescriptor.Position.INFIX, expressions){
                    static final long serialVersionUID = 23L;

                    @Override
                    public double evaluate(Context context) {
                        return this.getExpressions().get(0).evaluate(context) - this.getExpressions().get(1).evaluate(context);
                    }
                };
            }
            throw new ExpressionInitializationException("Must two arguments.");
        }
    }

    private static class AdditionExpressionDescriptor
    extends AbstractExpressionDescriptor {
        static final long serialVersionUID = 23L;

        public AdditionExpressionDescriptor() {
            super("Addition", "+", ExpressionDescriptor.Position.BOTH, true, true, true, new String[0]);
        }

        @Override
        public Expression createExpression(Expression ... expressions) throws ExpressionInitializationException {
            if (expressions.length > 0) {
                return new AbstractExpression("+", ExpressionDescriptor.Position.BOTH, expressions){
                    static final long serialVersionUID = 23L;

                    @Override
                    public double evaluate(Context context) {
                        double value = 0.0;
                        for (Expression exp : this.getExpressions()) {
                            value += exp.evaluate(context);
                        }
                        return value;
                    }
                };
            }
            throw new ExpressionInitializationException("Must have at least one argument.");
        }
    }

    private static class Comp
    implements Comparator<ExpressionDescriptor> {
        static final long serialVersionUID = 23L;

        private Comp() {
        }

        @Override
        public int compare(ExpressionDescriptor o1, ExpressionDescriptor o2) {
            return o1.getToken().compareTo(o2.getToken());
        }
    }
}

