/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.datamanip.ArResidualsParams;

public class ArResidualsWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ArResidualsWrapper(DataWrapper data, ArResidualsParams params) {
        DataModelList list = data.getDataModelList();
        DataModelList convertedList = new DataModelList();
        DataModelList dataSets = data.getDataModelList();
        for (int i = 0; i < list.size(); ++i) {
            DataModel selectedModel = dataSets.get(i);
            if (!(selectedModel instanceof DataSet)) continue;
            DataSet model = TimeSeriesUtils.var2((DataSet)selectedModel, params.getNumTimeLags());
            convertedList.add(model);
            this.setSourceGraph(data.getSourceGraph());
        }
        this.setDataModelList(convertedList);
        LogObjectsUtils.logDataModelList("Result data from an AR residual calculation.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new ArResidualsWrapper(DataWrapper.serializableInstance(), ArResidualsParams.serializableInstance());
    }
}

