/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;

public class ConvertNumericalDiscreteToContinuousWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ConvertNumericalDiscreteToContinuousWrapper(DataWrapper data) {
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("Data must be tabular");
        }
        DataSet originalData = (DataSet)model;
        DataSet convertedData = null;
        try {
            convertedData = DataUtils.convertNumericalDiscreteToContinuous(originalData);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("There were some non-numeric values in that dataset.");
        }
        this.setDataModel(convertedData);
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Data in which numerical discrete columns of parent node data have been expanded.", this.getDataModelList());
    }

    public static ConvertNumericalDiscreteToContinuousWrapper serializableInstance() {
        return new ConvertNumericalDiscreteToContinuousWrapper(DataWrapper.serializableInstance());
    }
}

