/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Discretizer;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.datamanip.DiscretizationParams;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.prefs.Preferences;

public class DiscretizationWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;
    private DataSet discretizedDataSet;

    public DiscretizationWrapper(DataWrapper data, DiscretizationParams params) {
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        if (params == null) {
            throw new NullPointerException("The given parameters must not be null");
        }
        DataSet originalData = (DataSet)data.getSelectedDataModel();
        Discretizer discretizer = new Discretizer(originalData, params.getSpecs());
        discretizer.setVariablesCopied(Preferences.userRoot().getBoolean("copyUnselectedColumns", false));
        this.discretizedDataSet = discretizer.discretize();
        this.setDataModel(this.discretizedDataSet);
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Discretization of data in the parent node.", this.getDataModelList());
    }

    public static DiscretizationWrapper serializableInstance() {
        return new DiscretizationWrapper(DataWrapper.serializableInstance(), DiscretizationParams.serializableInstance());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.discretizedDataSet == null) {
            throw new NullPointerException();
        }
    }
}

