/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.regression.RegressionUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.LogObjectsUtils;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import javax.swing.JOptionPane;

public class ResidualsWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ResidualsWrapper(DataWrapper data, DagWrapper dagWrapper) {
        DataModel dataModel = data.getSelectedDataModel();
        if (!(dataModel instanceof DataSet)) {
            throw new IllegalArgumentException("The data must be a rectangular dataset");
        }
        DataSet dataSet = (DataSet)dataModel;
        Dag dag = dagWrapper.getDag();
        dataSet = RegressionUtils.residuals(dataSet, dag);
        this.setDataModel(dataSet);
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Parent data in which each column has been replaced by its regression residuals.", this.getDataModelList());
    }

    public ResidualsWrapper(DataWrapper data, GraphWrapper graphWrapper) {
        Dag dag;
        DataModel dataModel = data.getSelectedDataModel();
        if (!(dataModel instanceof DataSet)) {
            throw new IllegalArgumentException("The data must be a rectangular dataset");
        }
        DataSet dataSet = (DataSet)dataModel;
        Graph graph = graphWrapper.getGraph();
        try {
            dag = new Dag(graph);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Not a DAG.");
            return;
        }
        dataSet = RegressionUtils.residuals(dataSet, dag);
        this.setDataModel(dataSet);
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Parent data in which each column has been replaced by its regression residuals.", this.getDataModelList());
    }

    public ResidualsWrapper(DataWrapper data, SemGraphWrapper wrapper) {
        Dag dag;
        DataModel dataModel = data.getSelectedDataModel();
        if (!(dataModel instanceof DataSet)) {
            throw new IllegalArgumentException("The data must be a rectangular dataset");
        }
        DataSet dataSet = (DataSet)dataModel;
        Graph graph = wrapper.getGraph();
        try {
            dag = new Dag(graph);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Not a DAG.");
            return;
        }
        dataSet = RegressionUtils.residuals(dataSet, dag);
        this.setDataModel(dataSet);
        this.setSourceGraph(data.getSourceGraph());
        LogObjectsUtils.logDataModelList("Parent data in which each column has been replaced by its regression residuals.", this.getDataModelList());
    }

    public static DataWrapper serializableInstance() {
        return new ResidualsWrapper(DataWrapper.serializableInstance(), DagWrapper.serializableInstance());
    }
}

