/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GraphEditorUtils {
    public static void editkamadaKawaiLayoutParams() {
        boolean initializeRandomly = Preferences.userRoot().getBoolean("kamadaKawaiLayoutInitializeRandomly", false);
        double naturalEdgeLength = Preferences.userRoot().getDouble("kamadaKawaiLayoutNaturalEdgeLength", 80.0);
        double springConstant = Preferences.userRoot().getDouble("kamadaKawaiLayoutSpringConstant", 0.2);
        double stopEnergy = Preferences.userRoot().getDouble("kamadaKawaiLayoutStopEnergy", 1.0);
        JComboBox<String> randomCombo = new JComboBox<String>(new String[]{"No", "Yes"});
        randomCombo.setMaximumSize(randomCombo.getPreferredSize());
        if (initializeRandomly) {
            randomCombo.setSelectedItem("Yes");
        }
        randomCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                String selection = (String)combo.getSelectedItem();
                if ("No".equals(selection)) {
                    Preferences.userRoot().putBoolean("kamadaKawaiLayoutInitializeRandomly", false);
                } else {
                    Preferences.userRoot().putBoolean("kamadaKawaiLayoutInitializeRandomly", true);
                }
            }
        });
        DoubleTextField naturalEdgeLengthField = new DoubleTextField(naturalEdgeLength, 4, NumberFormatUtil.getInstance().getNumberFormat());
        naturalEdgeLengthField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                if (value <= 0.0) {
                    return oldValue;
                }
                Preferences.userRoot().putDouble("kamadaKawaiLayoutNaturalEdgeLength", value);
                return value;
            }
        });
        DoubleTextField springConstantField = new DoubleTextField(springConstant, 4, NumberFormatUtil.getInstance().getNumberFormat());
        springConstantField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                if (value < 0.0) {
                    return oldValue;
                }
                Preferences.userRoot().putDouble("kamadaKawaiLayoutSpringConstant", value);
                return value;
            }
        });
        DoubleTextField stopEnergyField = new DoubleTextField(stopEnergy, 4, NumberFormatUtil.getInstance().getNumberFormat());
        stopEnergyField.setFilter(new DoubleTextField.Filter(){

            @Override
            public double filter(double value, double oldValue) {
                if (value < 0.0) {
                    return oldValue;
                }
                Preferences.userRoot().putDouble("kamadaKawaiLayoutStopEnergy", value);
                return value;
            }
        });
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Initialize randomly? "));
        b1.add(Box.createHorizontalGlue());
        b1.add(randomCombo);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Natural edge length: "));
        b2.add(Box.createHorizontalGlue());
        b2.add(naturalEdgeLengthField);
        b.add(b2);
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Strength of springs: "));
        b3.add(Box.createHorizontalGlue());
        b3.add(springConstantField);
        b.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Stop at energy = "));
        b4.add(Box.createHorizontalGlue());
        b4.add(stopEnergyField);
        b.add(b4);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)b, "Center");
        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), panel, "Spring Layout Parameters", -1);
    }
}

