/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.util.CopyLayoutAction;
import edu.cmu.tetradapp.util.GraphEditorUtils;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.PasteLayoutAction;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class LayoutMenu
extends JMenu {
    private LayoutEditable layoutEditable;
    private CopyLayoutAction copyLayoutAction;

    public LayoutMenu(LayoutEditable layoutEditable) {
        super("Layout");
        this.layoutEditable = layoutEditable;
        JMenuItem circleLayout = new JMenuItem("Circle");
        this.add(circleLayout);
        circleLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Graph graph = LayoutMenu.this.getLayoutEditable().getGraph();
                for (Node node : new ArrayList<Node>(graph.getNodes())) {
                    if (node.getNodeType() != NodeType.ERROR) continue;
                    graph.removeNode(node);
                }
                Rectangle r = LayoutMenu.this.getLayoutEditable().getVisibleRect();
                int m = Math.min(r.width, r.height) / 2;
                int radius = m - 50;
                int centerx = r.x + m;
                int centery = r.y + m;
                GraphUtils.arrangeInCircle(graph, centerx, centery, radius);
                LayoutMenu.this.getLayoutEditable().layoutByGraph(graph);
                LayoutMenu.this.getCopyLayoutAction().actionPerformed(null);
            }
        });
        if (this.getLayoutEditable().getKnowledge() != null) {
            JMenuItem knowledgeTiersLayout = new JMenuItem("Knowledge Tiers");
            this.add(knowledgeTiersLayout);
            knowledgeTiersLayout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        EdgeListGraph graph = new EdgeListGraph(LayoutMenu.this.getLayoutEditable().getGraph());
                        for (Node node : new ArrayList<Node>(graph.getNodes())) {
                            if (node.getNodeType() != NodeType.ERROR) continue;
                            graph.removeNode(node);
                        }
                        Knowledge knowledge = LayoutMenu.this.getLayoutEditable().getKnowledge();
                        SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
                        LayoutMenu.this.getLayoutEditable().layoutByGraph(graph);
                        LayoutMenu.this.getCopyLayoutAction().actionPerformed(null);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e1.getMessage());
                    }
                }
            });
        }
        if (this.getLayoutEditable().getSourceGraph() != null) {
            JMenuItem lastResultLayout = new JMenuItem("Source Graph");
            this.add(lastResultLayout);
            lastResultLayout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdgeListGraph graph = new EdgeListGraph(LayoutMenu.this.getLayoutEditable().getGraph());
                    for (Node node : new ArrayList<Node>(graph.getNodes())) {
                        if (node.getNodeType() != NodeType.ERROR) continue;
                        graph.removeNode(node);
                    }
                    Graph sourceGraph = LayoutMenu.this.getLayoutEditable().getSourceGraph();
                    GraphUtils.arrangeBySourceGraph(graph, sourceGraph);
                    LayoutMenu.this.getLayoutEditable().layoutByGraph(graph);
                    LayoutMenu.this.getCopyLayoutAction().actionPerformed(null);
                }
            });
        }
        JMenuItem layeredDrawing = new JMenuItem("Layered Drawing");
        this.add(layeredDrawing);
        layeredDrawing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Graph graph = LayoutMenu.this.getLayoutEditable().getGraph();
                for (Node node : new ArrayList<Node>(graph.getNodes())) {
                    if (node.getNodeType() != NodeType.ERROR) continue;
                    graph.removeNode(node);
                }
                GraphUtils.hierarchicalLayout(graph);
                LayoutMenu.this.getLayoutEditable().layoutByGraph(graph);
                LayoutMenu.this.getCopyLayoutAction().actionPerformed(null);
            }
        });
        JMenuItem fruchtermanReingold = new JMenuItem("Fruchterman-Reingold");
        this.add(fruchtermanReingold);
        fruchtermanReingold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Graph graph = LayoutMenu.this.getLayoutEditable().getGraph();
                for (Node node : new ArrayList<Node>(graph.getNodes())) {
                    if (node.getNodeType() != NodeType.ERROR) continue;
                    graph.removeNode(node);
                }
                GraphUtils.fruchtermanReingoldLayout(graph);
                LayoutMenu.this.getLayoutEditable().layoutByGraph(graph);
                LayoutMenu.this.getCopyLayoutAction().actionPerformed(null);
            }
        });
        JMenuItem kamadaKawai = new JMenuItem("Kamada-Kawai");
        this.add(kamadaKawai);
        kamadaKawai.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Graph graph = LayoutMenu.this.getLayoutEditable().getGraph();
                        for (Node node : new ArrayList<Node>(graph.getNodes())) {
                            if (node.getNodeType() != NodeType.ERROR) continue;
                            graph.removeNode(node);
                        }
                        GraphEditorUtils.editkamadaKawaiLayoutParams();
                        boolean initializeRandomly = Preferences.userRoot().getBoolean("kamadaKawaiLayoutInitializeRandomly", false);
                        double naturalEdgeLength = Preferences.userRoot().getDouble("kamadaKawaiLayoutNaturalEdgeLength", 80.0);
                        double springConstant = Preferences.userRoot().getDouble("kamadaKawaiLayoutSpringConstant", 0.2);
                        double stopEnergy = Preferences.userRoot().getDouble("kamadaKawaiLayoutStopEnergy", 1.0);
                        GraphUtils.kamadaKawaiLayout(graph, initializeRandomly, naturalEdgeLength, springConstant, stopEnergy);
                        LayoutMenu.this.getLayoutEditable().layoutByGraph(graph);
                        LayoutMenu.this.getCopyLayoutAction().actionPerformed(null);
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            }
        });
        this.addSeparator();
        this.copyLayoutAction = new CopyLayoutAction(this.getLayoutEditable());
        this.add(this.getCopyLayoutAction());
        this.add(new PasteLayoutAction(this.getLayoutEditable()));
    }

    private LayoutEditable getLayoutEditable() {
        return this.layoutEditable;
    }

    private CopyLayoutAction getCopyLayoutAction() {
        return this.copyLayoutAction;
    }
}

