/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

public class TextTable {
    public static int LEFT_JUSTIFIED = 0;
    public static int RIGHT_JUSTIFIED = 1;
    private String[][] tokens;
    private int justification = RIGHT_JUSTIFIED;
    private int columnSpacing = 2;

    public TextTable(int rows, int columns) {
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException();
        }
        this.tokens = new String[rows][columns];
        for (int i = 0; i < this.tokens.length; ++i) {
            for (int j = 0; j < this.tokens[0].length; ++j) {
                this.tokens[i][j] = "";
            }
        }
    }

    public void setToken(int row, int column, String token) {
        if (token == null) {
            throw new NullPointerException();
        }
        this.tokens[row][column] = token;
    }

    public String getTokenAt(int row, int column) {
        return this.tokens[row][column];
    }

    public int getNumRows() {
        return this.tokens.length;
    }

    public int getNumColumns() {
        return this.tokens[0].length;
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public void setColumnSpacing(int numSpaces) {
        if (numSpaces < 0) {
            throw new IllegalArgumentException();
        }
        this.columnSpacing = numSpaces;
    }

    public int getJustification() {
        return this.justification;
    }

    public void setJustification(int justification) {
        if (justification != LEFT_JUSTIFIED && justification != RIGHT_JUSTIFIED) {
            throw new IllegalArgumentException();
        }
        this.justification = justification;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int[] colWidths = new int[this.tokens[0].length];
        for (int j = 0; j < this.tokens[0].length; ++j) {
            for (String[] token : this.tokens) {
                if (token[j].length() <= colWidths[j]) continue;
                colWidths[j] = token[j].length();
            }
        }
        for (String[] token1 : this.tokens) {
            buffer.append("\n");
            for (int j = 0; j < this.tokens[0].length; ++j) {
                int k;
                for (int k2 = 0; k2 < this.getColumnSpacing(); ++k2) {
                    buffer.append(' ');
                }
                int numPaddingSpaces = colWidths[j] - token1[j].length();
                if (this.getJustification() == RIGHT_JUSTIFIED) {
                    for (k = 0; k < numPaddingSpaces; ++k) {
                        buffer.append(' ');
                    }
                }
                buffer.append(token1[j]);
                if (this.getJustification() != LEFT_JUSTIFIED) continue;
                for (k = 0; k < numPaddingSpaces; ++k) {
                    buffer.append(' ');
                }
            }
        }
        return buffer.toString();
    }
}

