/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.util.TetradSerializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private int majorVersion;
    private int minorVersion;
    private int minorSubversion;
    private int incrementalRelease;

    public Version(String spec) {
        if (spec == null) {
            throw new NullPointerException();
        }
        Pattern pattern = Pattern.compile("(\\d*)\\.(\\d*)\\.(\\d*)-(\\d*)");
        Matcher matcher = pattern.matcher(spec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Spec not of form a.b.c-d");
        }
        this.majorVersion = Integer.parseInt(matcher.group(1));
        this.minorVersion = Integer.parseInt(matcher.group(2));
        this.minorSubversion = Integer.parseInt(matcher.group(3));
        this.incrementalRelease = Integer.parseInt(matcher.group(4));
    }

    public Version(int majorVersion, int minorVersion, int minorSubversion, int incrementalRelease) {
        if (majorVersion < 0) {
            throw new IllegalArgumentException();
        }
        if (minorVersion < 0) {
            throw new IllegalArgumentException();
        }
        if (minorSubversion < 0) {
            throw new IllegalArgumentException();
        }
        if (incrementalRelease < 0) {
            throw new IllegalArgumentException();
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.minorSubversion = minorSubversion;
        this.incrementalRelease = incrementalRelease;
    }

    public static Version currentRepositoryVersion() {
        try {
            File file = new File("project/resources/version");
            FileReader fileReader = new FileReader(file);
            BufferedReader bufReader = new BufferedReader(fileReader);
            String spec = bufReader.readLine();
            bufReader.close();
            return new Version(spec);
        }
        catch (IOException e) {
            throw new RuntimeException("Please correct the file project/resources/version \nso that it contains a version number of the form \na.b.c-d, where a, b, c, and a are integers. It should have \nbeen in CVS. Try doing cvs up or looking in an recent version \nof the repository in case someone removed it. This should be \nthe version of last published version of Tetrad.");
        }
    }

    public static Version currentViewableVersion() {
        try {
            String path = "/resources/version";
            URL url = Version.class.getResource(path);
            if (url == null) {
                throw new RuntimeException("Please run 'ant copyresources' and try again. The problem \nis that the file /resources/version is not in the ejar build.");
            }
            InputStream inStream = url.openStream();
            InputStreamReader reader = new InputStreamReader(inStream);
            BufferedReader bufReader = new BufferedReader(reader);
            String spec = bufReader.readLine();
            bufReader.close();
            return new Version(spec);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Please correct the file project/resources/version \nso that it contains a version number of the form \na.b.c-d, where a, b, c, and a are integers. It should have \nbeen in CVS. Try doing cvs up or looking in an recent version \nof the repository in case someone removed it. This should be \nthe version of last published version of Tetrad.");
        }
    }

    public static Version serializableInstance() {
        return new Version("4.3.1-5");
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public int minorSubversion() {
        return this.minorSubversion;
    }

    public int incrementalRelease() {
        return this.incrementalRelease;
    }

    public int hashCode() {
        int hashCode = 61;
        hashCode += 61 * this.majorVersion;
        hashCode += 61 * this.minorVersion;
        hashCode += 61 * this.minorSubversion;
        return hashCode += this.incrementalRelease;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        if (this.minorSubversion != other.minorSubversion) {
            return false;
        }
        return this.incrementalRelease == other.incrementalRelease;
    }

    public String toString() {
        return this.majorVersion() + "." + this.minorVersion() + "." + this.minorSubversion() + "-" + this.incrementalRelease();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.majorVersion < 0) {
            throw new IllegalStateException();
        }
        if (this.minorVersion < 0) {
            throw new IllegalStateException();
        }
        if (this.minorSubversion < 0) {
            throw new IllegalStateException();
        }
        if (this.incrementalRelease < 0) {
            throw new IllegalStateException();
        }
    }

    public Version nextMajorVersion() {
        int majorVersion = this.majorVersion + 1;
        int minorVersion = 0;
        int minorSubversion = 0;
        int incrementalRelease = 0;
        return new Version(majorVersion, minorVersion, minorSubversion, incrementalRelease);
    }

    public Version nextMinorVersion() {
        int majorVersion = this.majorVersion;
        int minorVersion = this.minorVersion + 1;
        int minorSubversion = 0;
        int incrementalRelease = 0;
        return new Version(majorVersion, minorVersion, minorSubversion, incrementalRelease);
    }

    public Version nextMinorSubversion() {
        int majorVersion = this.majorVersion;
        int minorVersion = this.minorVersion;
        int minorSubversion = this.minorSubversion + 1;
        int incrementalRelease = 0;
        return new Version(majorVersion, minorVersion, minorSubversion, incrementalRelease);
    }

    public Version nextIncrementalRelease() {
        int majorVersion = this.majorVersion;
        int minorVersion = this.minorVersion;
        int minorSubversion = this.minorSubversion;
        int incrementalRelease = this.incrementalRelease + 1;
        return new Version(majorVersion, minorVersion, minorSubversion, incrementalRelease);
    }
}

