/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.util.JOptionUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public abstract class WatchedProcess {
    private Thread thread;
    private String errorMessage;
    private final long delay = 200L;
    private JDialog stopDialog;
    private Window owner;
    private static boolean SHOW_DIALOG = true;
    private Component centeringComp;

    public WatchedProcess(Window owner) {
        this(owner, JOptionUtils.centeringComp());
    }

    public WatchedProcess(Window owner, Component centeringComp) {
        if (owner == null) {
            throw new NullPointerException();
        }
        this.owner = owner;
        this.centeringComp = centeringComp;
        this.watchProcess();
    }

    public abstract void watch();

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public JDialog getStopDialog() {
        return this.stopDialog;
    }

    public void setStopDialog(JDialog stopDialog) {
        this.stopDialog = stopDialog;
    }

    public Window getOwner() {
        return this.owner;
    }

    public boolean isShowDialog() {
        return SHOW_DIALOG;
    }

    public void setShowDialog(boolean showDialog) {
        SHOW_DIALOG = showDialog;
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }

    private void watchProcess() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    WatchedProcess.this.watch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = e.getMessage();
                    if (e.getCause() != null) {
                        message = e.getCause().getMessage();
                    }
                    WatchedProcess.this.setErrorMessage(message);
                }
            }
        };
        Thread thread = new Thread(runnable);
        this.setThread(thread);
        thread.start();
        if (this.isShowDialog()) {
            Thread watcher = new Thread(){

                @Override
                public void run() {
                    try {
                        2.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (WatchedProcess.this.getErrorMessage() != null) {
                        JOptionPane.showMessageDialog(WatchedProcess.this.centeringComp, "Stopped with error:\n" + WatchedProcess.this.getErrorMessage());
                        return;
                    }
                    JProgressBar progressBar = new JProgressBar(0, 100);
                    progressBar.setIndeterminate(true);
                    JButton stopButton = new JButton("Stop");
                    stopButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (WatchedProcess.this.getThread() != null) {
                                while (WatchedProcess.this.getThread().isAlive()) {
                                    WatchedProcess.this.getThread().stop();
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException e1) {
                                        JOptionPane.showMessageDialog(WatchedProcess.this.centeringComp, "Could not stop thread.");
                                        return;
                                    }
                                }
                            }
                        }
                    });
                    Box b = Box.createVerticalBox();
                    Box b1 = Box.createHorizontalBox();
                    b1.add(progressBar);
                    b1.add(stopButton);
                    b.add(b1);
                    if (WatchedProcess.this.isShowDialog()) {
                        Frame ancestor = (Frame)JOptionUtils.centeringComp().getTopLevelAncestor();
                        JDialog dialog = new JDialog(ancestor, "Executing...", false);
                        WatchedProcess.this.setStopDialog(dialog);
                        dialog.getContentPane().add(b);
                        dialog.pack();
                        dialog.setLocationRelativeTo(WatchedProcess.this.centeringComp);
                        while (WatchedProcess.this.getThread().isAlive()) {
                            try {
                                2.sleep(200L);
                                if (WatchedProcess.this.existsOtherDialog()) {
                                    dialog.setVisible(false);
                                    continue;
                                }
                                dialog.setVisible(true);
                                dialog.toFront();
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        dialog.setVisible(false);
                        dialog.dispose();
                        if (WatchedProcess.this.getErrorMessage() != null) {
                            JOptionPane.showMessageDialog(WatchedProcess.this.centeringComp, "Stopped with error:\n" + WatchedProcess.this.getErrorMessage());
                        }
                    }
                }
            };
            watcher.start();
        }
    }

    private Thread getThread() {
        return this.thread;
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }

    private boolean existsOtherDialog() {
        Window[] ownedWindows;
        Frame ancestor = (Frame)JOptionUtils.centeringComp().getTopLevelAncestor();
        for (Window window : ownedWindows = ancestor.getOwnedWindows()) {
            Dialog dialog;
            if (!(window instanceof Dialog) || window == this.getStopDialog() || window == this.getOwner() || !(dialog = (Dialog)window).isVisible()) continue;
            return true;
        }
        return false;
    }
}

