/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetradapp.workbench.DisplayComp;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class ErrorDisplayComp
extends JComponent
implements DisplayComp {
    private boolean selected = false;

    public ErrorDisplayComp(String name) {
        this.setBackground(DisplayNodeUtils.getNodeFillColor());
        this.setFont(DisplayNodeUtils.getFont());
        this.setName(name);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getShape().contains(x, y);
    }

    public Shape getShape() {
        return new Rectangle2D.Double(0.0, 0.0, this.getPreferredSize().width - 1, this.getPreferredSize().height - 1);
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fm = this.getFontMetrics(DisplayNodeUtils.getFont());
        Dimension size = this.getPreferredSize();
        int stringWidth = fm.stringWidth(this.getName());
        int stringX = (size.width - stringWidth) / 2;
        int stringY = fm.getAscent() + (size.height - fm.getHeight()) / 2;
        g.setColor(DisplayNodeUtils.getNodeTextColor());
        g.drawString(this.getName(), stringX, stringY);
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(DisplayNodeUtils.getFont());
        int width = fm.stringWidth(this.getName()) + fm.getMaxAdvance();
        int height = 2 * DisplayNodeUtils.getPixelGap() + fm.getAscent();
        return new Dimension(width, height);
    }

    public boolean isSelected() {
        return this.selected;
    }
}

