/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import jdepend.framework.AbstractParser;
import jdepend.framework.FileManager;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;

public class JavaClassFileParser
extends AbstractParser {
    public static final int JAVA_MAGIC = -889275714;
    public static final int CONSTANT_UTF8 = 1;
    public static final int CONSTANT_UNICODE = 2;
    public static final int CONSTANT_INTEGER = 3;
    public static final int CONSTANT_FLOAT = 4;
    public static final int CONSTANT_LONG = 5;
    public static final int CONSTANT_DOUBLE = 6;
    public static final int CONSTANT_CLASS = 7;
    public static final int CONSTANT_STRING = 8;
    public static final int CONSTANT_FIELD = 9;
    public static final int CONSTANT_METHOD = 10;
    public static final int CONSTANT_INTERFACEMETHOD = 11;
    public static final int CONSTANT_NAMEANDTYPE = 12;
    public static final char CLASS_DESCRIPTOR = 'L';
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    private String _className;
    private String _superClassName;
    private String[] _interfaceNames;
    private boolean _isAbstract;
    private JavaClass _jClass;
    private Constant[] _constantPool;
    private FieldOrMethodInfo[] _fields;
    private FieldOrMethodInfo[] _methods;
    private DataInputStream _in;

    public JavaClassFileParser() {
        this(new PackageFilter());
    }

    public JavaClassFileParser(PackageFilter packageFilter) {
        super(packageFilter);
        this.reset();
    }

    protected void reset() {
        this._className = null;
        this._superClassName = null;
        this._interfaceNames = new String[0];
        this._isAbstract = false;
        this._jClass = null;
        this._constantPool = new Constant[1];
        this._fields = new FieldOrMethodInfo[0];
        this._methods = new FieldOrMethodInfo[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JavaClass parse(String string) throws IOException {
        JavaClass javaClass;
        File file = new File(string);
        if (!FileManager.acceptClassFile(file)) {
            throw new IOException("Invalid class file: " + string);
        }
        this.debug("\nParsing " + string + "...");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            javaClass = this.parse(fileInputStream);
            Object var6_5 = null;
            if (fileInputStream == null) return javaClass;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
            return javaClass;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return javaClass;
    }

    protected JavaClass parse(InputStream inputStream) throws IOException {
        this.reset();
        this._jClass = new JavaClass();
        this._in = new DataInputStream(inputStream);
        this.parseMagic();
        this.parseVersion();
        this.parseConstantPool();
        this.parseAccessFlags();
        this.parseClassName();
        this.parseSuperClassName();
        this.parseInterfaces();
        this.parseFields();
        this.parseMethods();
        this.addClassConstantReferences();
        this.onParsedJavaClass(this._jClass);
        return this._jClass;
    }

    protected void parseMagic() throws IOException {
        int n = this._in.readInt();
        if (n != -889275714) {
            throw new IOException("Illegal magic number: " + n);
        }
    }

    protected void parseVersion() throws IOException {
        int n = this._in.readUnsignedShort();
        int n2 = this._in.readUnsignedShort();
    }

    protected void parseConstantPool() throws IOException {
        int n = this._in.readUnsignedShort();
        this._constantPool = new Constant[n];
        int n2 = 1;
        while (n2 < n) {
            Constant constant;
            this._constantPool[n2] = constant = this.parseConstant();
            if (constant.getTag() == 6 || constant.getTag() == 5) {
                ++n2;
            }
            ++n2;
        }
    }

    protected void parseAccessFlags() throws IOException {
        int n = this._in.readUnsignedShort();
        boolean bl = (n & 0x400) != 0;
        boolean bl2 = (n & 0x200) != 0;
        this._isAbstract = bl || bl2;
        this._jClass.isAbstract(this._isAbstract);
        this.debug("Parser: abstract = " + this._isAbstract);
    }

    protected void parseClassName() throws IOException {
        int n = this._in.readUnsignedShort();
        this._className = this.getClassConstantName(n);
        this._jClass.setName(this._className);
        this._jClass.setPackageName(this.getPackageName(this._className));
        this.debug("Parser: class name = " + this._className);
        this.debug("Parser: package name = " + this.getPackageName(this._className));
    }

    protected void parseSuperClassName() throws IOException {
        int n = this._in.readUnsignedShort();
        this._superClassName = this.getClassConstantName(n);
        this.addImport(this.getPackageName(this._superClassName));
        this.debug("Parser: super class name = " + this._superClassName);
    }

    protected void parseInterfaces() throws IOException {
        int n = this._in.readUnsignedShort();
        this._interfaceNames = new String[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this._in.readUnsignedShort();
            this._interfaceNames[n2] = this.getClassConstantName(n3);
            this.addImport(this.getPackageName(this._interfaceNames[n2]));
            this.debug("Parser: interface = " + this._interfaceNames[n2]);
            ++n2;
        }
    }

    protected void parseFields() throws IOException {
        int n = this._in.readUnsignedShort();
        this._fields = new FieldOrMethodInfo[n];
        int n2 = 0;
        while (n2 < n) {
            this._fields[n2] = this.parseFieldOrMethodInfo();
            String string = this.toUTF8(this._fields[n2].getDescriptorIndex());
            this.debug("Parser: field descriptor = " + string);
            String[] stringArray = this.descriptorToTypes(string);
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.addImport(this.getPackageName(stringArray[n3]));
                this.debug("Parser: field type = " + stringArray[n3]);
                ++n3;
            }
            ++n2;
        }
    }

    protected void parseMethods() throws IOException {
        int n = this._in.readUnsignedShort();
        this._methods = new FieldOrMethodInfo[n];
        int n2 = 0;
        while (n2 < n) {
            this._methods[n2] = this.parseFieldOrMethodInfo();
            String string = this.toUTF8(this._methods[n2].getDescriptorIndex());
            this.debug("Parser: method descriptor = " + string);
            String[] stringArray = this.descriptorToTypes(string);
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].length() > 0) {
                    this.addImport(this.getPackageName(stringArray[n3]));
                    this.debug("Parser: method type = " + stringArray[n3]);
                }
                ++n3;
            }
            ++n2;
        }
    }

    protected Constant parseConstant() throws IOException {
        Constant constant;
        byte by = this._in.readByte();
        switch (by) {
            case 7: 
            case 8: {
                constant = new Constant(by, this._in.readUnsignedShort());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                constant = new Constant(by, this._in.readUnsignedShort(), this._in.readUnsignedShort());
                break;
            }
            case 3: {
                constant = new Constant(by, new Integer(this._in.readInt()));
                break;
            }
            case 4: {
                constant = new Constant(by, new Float(this._in.readFloat()));
                break;
            }
            case 5: {
                constant = new Constant(by, new Long(this._in.readLong()));
                break;
            }
            case 6: {
                constant = new Constant(by, new Double(this._in.readDouble()));
                break;
            }
            case 1: {
                constant = new Constant(by, this._in.readUTF());
                break;
            }
            default: {
                throw new IOException("Unknown constant: " + by);
            }
        }
        return constant;
    }

    protected FieldOrMethodInfo parseFieldOrMethodInfo() throws IOException {
        FieldOrMethodInfo fieldOrMethodInfo = new FieldOrMethodInfo(this._in.readUnsignedShort(), this._in.readUnsignedShort(), this._in.readUnsignedShort());
        int n = this._in.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            this.parseAttribute();
            ++n2;
        }
        return fieldOrMethodInfo;
    }

    protected void parseAttribute() throws IOException {
        int n = this._in.readUnsignedShort();
        int n2 = this._in.readInt();
        int n3 = 0;
        while (n3 < n2) {
            byte by = this._in.readByte();
            ++n3;
        }
    }

    protected Constant getConstantPoolEntry(int n) throws IOException {
        if (n < 0 || n >= this._constantPool.length) {
            throw new IOException("Illegal constant pool index : " + n);
        }
        return this._constantPool[n];
    }

    protected void addClassConstantReferences() throws IOException {
        int n = 1;
        while (n < this._constantPool.length) {
            if (this._constantPool[n].getTag() == 7) {
                String string = this.toUTF8(this._constantPool[n].getNameIndex());
                this.addImport(this.getPackageName(string));
                this.debug("Parser: class type = " + this.slashesToDots(string));
            }
            if (this._constantPool[n].getTag() == 6 || this._constantPool[n].getTag() == 5) {
                ++n;
            }
            ++n;
        }
    }

    protected String getClassConstantName(int n) throws IOException {
        Constant constant = this.getConstantPoolEntry(n);
        if (constant == null) {
            return "";
        }
        return this.slashesToDots(this.toUTF8(constant.getNameIndex()));
    }

    protected String toUTF8(int n) throws IOException {
        Constant constant = this.getConstantPoolEntry(n);
        if (constant.getTag() == 1) {
            return (String)constant.getValue();
        }
        throw new IOException("Constant pool entry is not a UTF8 type: " + n);
    }

    protected boolean isAbstract() {
        return this._isAbstract;
    }

    protected String getClassName() {
        return this._className;
    }

    protected String getSuperClassName() {
        return this._superClassName;
    }

    protected String[] getInterfaceNames() {
        return this._interfaceNames;
    }

    protected Collection getImports() {
        return this._jClass.getImportedPackages();
    }

    private void addImport(String string) {
        if (string != null && this.getFilter().accept(string)) {
            this._jClass.addImportedPackage(new JavaPackage(string));
        }
    }

    private String slashesToDots(String string) {
        return string.replace('/', '.');
    }

    private String getPackageName(String string) {
        int n;
        if (string.length() > 0 && string.charAt(0) == '[') {
            String[] stringArray = this.descriptorToTypes(string);
            if (stringArray.length == 0) {
                return null;
            }
            string = stringArray[0];
        }
        if ((n = (string = this.slashesToDots(string)).lastIndexOf(".")) > 0) {
            return string.substring(0, n);
        }
        return "Default";
    }

    private String[] descriptorToTypes(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == ';') {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            int n5 = string.indexOf(76, n4);
            if (n5 < 0) break;
            n4 = string.indexOf(59, n5 + 1);
            stringArray[n3++] = string.substring(n5 + 1, n4);
            ++n4;
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("\n" + this.getClassName() + ":\n");
            stringBuffer.append("\nConstants:\n");
            int n = 1;
            while (n < this._constantPool.length) {
                Constant constant = this.getConstantPoolEntry(n);
                stringBuffer.append("    " + n + ". " + constant.toString() + "\n");
                if (constant.getTag() == 6 || constant.getTag() == 5) {
                    ++n;
                }
                ++n;
            }
            stringBuffer.append("\nClass Name: " + this.getClassName() + "\n");
            stringBuffer.append("Super Name: " + this.getSuperClassName() + "\n\n");
            stringBuffer.append(this._interfaceNames.length + " interfaces\n");
            int n2 = 0;
            while (n2 < this._interfaceNames.length) {
                stringBuffer.append("    " + this._interfaceNames[n2] + "\n");
                ++n2;
            }
            stringBuffer.append("\n" + this._fields.length + " fields\n");
            int n3 = 0;
            while (n3 < this._fields.length) {
                stringBuffer.append(this._fields[n3].toString() + "\n");
                ++n3;
            }
            stringBuffer.append("\n" + this._methods.length + " methods\n");
            int n4 = 0;
            while (n4 < this._methods.length) {
                stringBuffer.append(this._methods[n4].toString() + "\n");
                ++n4;
            }
            stringBuffer.append("\nDependencies:\n");
            Iterator iterator = this._jClass.getImportedPackages().iterator();
            while (iterator.hasNext()) {
                JavaPackage javaPackage = (JavaPackage)iterator.next();
                stringBuffer.append("    " + javaPackage.getName() + "\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            AbstractParser.DEBUG = true;
            if (stringArray.length > 0) {
                JavaClassFileParser javaClassFileParser = new JavaClassFileParser();
                javaClassFileParser.parse(stringArray[0]);
                System.err.println(javaClassFileParser.toString());
            } else {
                System.err.println("usage: JavaClassFileParser <file>");
                System.exit(0);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    class FieldOrMethodInfo {
        private int _accessFlags;
        private int _nameIndex;
        private int _descriptorIndex;

        FieldOrMethodInfo(int n, int n2, int n3) {
            this._accessFlags = n;
            this._nameIndex = n2;
            this._descriptorIndex = n3;
        }

        int accessFlags() {
            return this._accessFlags;
        }

        int getNameIndex() {
            return this._nameIndex;
        }

        int getDescriptorIndex() {
            return this._descriptorIndex;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("");
            try {
                stringBuffer.append("\n    name (#" + this.getNameIndex() + ") = " + JavaClassFileParser.this.toUTF8(this.getNameIndex()));
                stringBuffer.append("\n    signature (#" + this.getDescriptorIndex() + ") = " + JavaClassFileParser.this.toUTF8(this.getDescriptorIndex()));
                String[] stringArray = JavaClassFileParser.this.descriptorToTypes(JavaClassFileParser.this.toUTF8(this.getDescriptorIndex()));
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append("\n        type = " + stringArray[n]);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return stringBuffer.toString();
        }
    }

    class Constant {
        private byte _tag;
        private int _nameIndex;
        private int _typeIndex;
        private Object _value;

        Constant(byte by, int n) {
            this(by, n, -1);
        }

        Constant(byte by, Object object) {
            this(by, -1, -1);
            this._value = object;
        }

        Constant(byte by, int n, int n2) {
            this._tag = by;
            this._nameIndex = n;
            this._typeIndex = n2;
            this._value = null;
        }

        byte getTag() {
            return this._tag;
        }

        int getNameIndex() {
            return this._nameIndex;
        }

        int getTypeIndex() {
            return this._typeIndex;
        }

        Object getValue() {
            return this._value;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("tag: " + this.getTag());
            if (this.getNameIndex() > -1) {
                stringBuffer.append(" nameIndex: " + this.getNameIndex());
            }
            if (this.getTypeIndex() > -1) {
                stringBuffer.append(" typeIndex: " + this.getTypeIndex());
            }
            if (this.getValue() != null) {
                stringBuffer.append(" value: " + this.getValue());
            }
            return stringBuffer.toString();
        }
    }
}

