/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import jdepend.framework.AbstractParser;
import jdepend.framework.FileManager;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;

public class JavaSourceFileParser
extends AbstractParser {
    private static final String PACKAGE_PATTERN = "package";
    private static final String IMPORT_PATTERN = "import";
    private static final String CLASS_PATTERN = "class";
    private static final String ABSTRACT_PATTERN = "abstract";
    private static final String INTERFACE_PATTERN = "interface";
    private static final String[] CLASS_MODIFIER_PATTERNS = new String[]{"public", "protected", "private", "abstract", "static", "final", "strictfp"};
    private static boolean _isCommented = false;

    public JavaSourceFileParser() {
        this(new PackageFilter());
    }

    public JavaSourceFileParser(PackageFilter packageFilter) {
        super(packageFilter);
    }

    /*
     * Unable to fully structure code
     */
    public JavaClass parse(String var1_1) throws IOException {
        var2_2 = new File(var1_1);
        if (!FileManager.acceptSourceFile(var2_2)) {
            throw new IOException("Invalid source file: " + var1_1);
        }
        this.debug("\nParsing " + var1_1 + "...");
        var3_3 = new JavaClass();
        var4_4 = 0;
        var5_5 = null;
        try {
            var6_6 = new FileInputStream(var2_2);
            var5_5 = new BufferedReader(new InputStreamReader(var6_6));
            var7_7 = true;
            var8_8 = var5_5.readLine();
            if (true) ** GOTO lbl33
            do {
                if (this.hasCommentPattern(var8_8)) {
                    ++var4_4;
                    var8_8 = var5_5.readLine();
                } else {
                    if (this.hasPackagePattern(var8_8)) {
                        this.addPackageName(var3_3, var8_8);
                    }
                    if (this.hasImportPattern(var8_8)) {
                        this.addImport(var3_3, var8_8);
                    }
                    if (this.hasClassPattern(var8_8) || this.hasInterfacePattern(var8_8)) {
                        if (this.hasClassPattern(var8_8)) {
                            this.addClassName(var3_3, var8_8);
                        }
                        if (this.hasInterfacePattern(var8_8)) {
                            this.addInterfaceName(var3_3, var8_8);
                        }
                        if (this.hasAbstractPattern(var8_8)) {
                            this.markAbstract(var3_3);
                        }
                        var7_7 = false;
                    }
                    ++var4_4;
                    var8_8 = var5_5.readLine();
                }
lbl33:
                // 3 sources

                if (var8_8 == null) break;
            } while (var7_7);
            var10_9 = null;
            ** if (var5_5 == null) goto lbl-1000
        }
        catch (Throwable var9_13) {
            var10_10 = null;
            if (var5_5 != null) {
                try {
                    var5_5.close();
                }
                catch (IOException var11_12) {
                    var11_12.printStackTrace();
                }
            }
            throw var9_13;
        }
lbl-1000:
        // 1 sources

        {
            try {
                var5_5.close();
            }
            catch (IOException var11_11) {
                var11_11.printStackTrace();
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var3_3.getName() == null) {
            throw new IOException("Unable to identify class name in source file: \n'" + var1_1 + "'.");
        }
        this.onParsedJavaClass(var3_3);
        return var3_3;
    }

    protected boolean hasCommentPattern(String string) {
        int n = string.indexOf("//");
        if (n >= 0) {
            return !this.isCommentTrailing(string, n);
        }
        n = string.indexOf("/*");
        if (n >= 0) {
            _isCommented = true;
        }
        if ((n = string.indexOf("*/")) >= 0) {
            _isCommented = false;
            return true;
        }
        return _isCommented;
    }

    protected boolean isCommentTrailing(String string, int n) {
        int n2 = string.indexOf(CLASS_PATTERN);
        if (n2 >= 0) {
            return n > n2;
        }
        int n3 = string.indexOf(INTERFACE_PATTERN);
        if (n3 >= 0) {
            return n > n3;
        }
        return false;
    }

    protected boolean hasPackagePattern(String string) {
        return string.trim().indexOf(PACKAGE_PATTERN) == 0;
    }

    protected void addPackageName(JavaClass javaClass, String string) {
        String string2 = this.parsePackageName(string);
        javaClass.setPackageName(string2);
        this.debug("Parser: package = " + string2 + "\nline = " + string);
    }

    protected String parsePackageName(String string) {
        int n = PACKAGE_PATTERN.length() + 1;
        int n2 = string.indexOf(";");
        if (n2 == -1) {
            return string.substring(n);
        }
        return string.substring(n, n2).trim();
    }

    protected boolean hasImportPattern(String string) {
        return string.trim().indexOf(IMPORT_PATTERN) == 0;
    }

    protected void addImport(JavaClass javaClass, String string) {
        String string2 = this.parseImport(string);
        if (this.getFilter().accept(string2)) {
            javaClass.addImportedPackage(new JavaPackage(string2));
            this.debug("Parser: import = " + string2 + "\nline = " + string);
        }
    }

    protected String parseImport(String string) {
        int n = IMPORT_PATTERN.length() + 1;
        int n2 = string.indexOf(";");
        int n3 = string.lastIndexOf(".");
        if (n3 > 0) {
            n2 = n3;
        }
        if (n2 > 0) {
            return string.substring(n, n2).trim();
        }
        return "";
    }

    protected boolean hasClassPattern(String string) {
        if (string.indexOf("(") > 0 || string.endsWith(";")) {
            return false;
        }
        if (this.hasClassModifier(string)) {
            int n = this.getClassModifierIndex(string);
            int n2 = string.indexOf(CLASS_PATTERN);
            return n2 > 0 && n < n2;
        }
        return string.trim().indexOf(CLASS_PATTERN) == 0;
    }

    protected void addClassName(JavaClass javaClass, String string) {
        String string2 = this.parseClassName(string);
        javaClass.setName(string2);
        javaClass.isAbstract(false);
        this.debug("Parser: class = " + string2 + "\nline = " + string);
    }

    protected String parseClassName(String string) {
        int n = string.indexOf(CLASS_PATTERN) + CLASS_PATTERN.length() + 1;
        String string2 = string.substring(n);
        int n2 = string2.indexOf(" ");
        if (n2 == -1) {
            return string2.substring(0);
        }
        return string2.substring(0, n2).trim();
    }

    protected boolean hasInterfacePattern(String string) {
        if (string.indexOf("(") > 0 || string.endsWith(";")) {
            return false;
        }
        if (this.hasClassModifier(string)) {
            int n = this.getClassModifierIndex(string);
            int n2 = string.indexOf(INTERFACE_PATTERN);
            return n2 > 0 && n < n2;
        }
        return string.trim().indexOf(INTERFACE_PATTERN) == 0;
    }

    protected void addInterfaceName(JavaClass javaClass, String string) {
        String string2 = this.parseInterfaceName(string);
        javaClass.setName(string2);
        javaClass.isAbstract(true);
        this.debug("Parser: interface = " + string2 + "\nline = " + string);
    }

    protected String parseInterfaceName(String string) {
        int n = string.indexOf(INTERFACE_PATTERN) + INTERFACE_PATTERN.length() + 1;
        String string2 = string.substring(n);
        int n2 = string2.indexOf(" ");
        if (n2 == -1) {
            return string2.substring(0);
        }
        return string2.substring(0, n2).trim();
    }

    protected boolean hasAbstractPattern(String string) {
        int n;
        return (this.hasClassPattern(string) || this.hasInterfacePattern(string)) && (n = string.indexOf(ABSTRACT_PATTERN)) >= 0;
    }

    protected void markAbstract(JavaClass javaClass) {
        javaClass.isAbstract(true);
        this.debug("Parser: abstract: " + javaClass.getName());
    }

    protected boolean hasClassModifier(String string) {
        return this.getClassModifierIndex(string) != -1;
    }

    protected int getClassModifierIndex(String string) {
        int n = 0;
        while (n < CLASS_MODIFIER_PATTERNS.length) {
            int n2 = string.indexOf(CLASS_MODIFIER_PATTERNS[n]);
            if (n2 >= 0) {
                return n2;
            }
            ++n;
        }
        return -1;
    }
}

