/*
 * Decompiled with CFR 0.152.
 */
package linear_algebra;

public class Blas_f77 {
    public static int isamax_f77(int n, double[] x, int incx) {
        int isamax;
        if (n < 1) {
            isamax = 0;
        } else if (n == 1) {
            isamax = 1;
        } else if (incx == 1) {
            isamax = 1;
            double xmax = Math.abs(x[1]);
            int i = 2;
            while (i <= n) {
                if (Math.abs(x[i]) > xmax) {
                    isamax = i;
                    xmax = Math.abs(x[i]);
                }
                ++i;
            }
        } else {
            isamax = 1;
            int ix = 1;
            double xmax = Math.abs(x[ix]);
            ix += incx;
            int i = 2;
            while (i <= n) {
                if (Math.abs(x[ix]) > xmax) {
                    isamax = i;
                    xmax = Math.abs(x[ix]);
                }
                ix += incx;
                ++i;
            }
        }
        return isamax;
    }

    public static int colisamax_f77(int n, double[][] x, int incx, int begin, int j) {
        int isamax;
        if (n < 1) {
            isamax = 0;
        } else if (n == 1) {
            isamax = 1;
        } else if (incx == 1) {
            isamax = 1;
            int ix = begin;
            double xmax = Math.abs(x[ix][j]);
            ++ix;
            int i = 2;
            while (i <= n) {
                if (Math.abs(x[ix][j]) > xmax) {
                    isamax = i;
                    xmax = Math.abs(x[ix][j]);
                }
                ++ix;
                ++i;
            }
        } else {
            isamax = 1;
            int ix = begin;
            double xmax = Math.abs(x[ix][j]);
            ix += incx;
            int i = 2;
            while (i <= n) {
                if (Math.abs(x[ix][j]) > xmax) {
                    isamax = i;
                    xmax = Math.abs(x[ix][j]);
                }
                ix += incx;
                ++i;
            }
        }
        return isamax;
    }

    public static void daxpy_f77(int n, double da, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0) {
            return;
        }
        if (da == 0.0) {
            return;
        }
        if (incx == 1 && incy == 1) {
            int m = n % 4;
            int i = 1;
            while (i <= m) {
                int n2 = i;
                dy[n2] = dy[n2] + da * dx[i];
                ++i;
            }
            i = m + 1;
            while (i <= n) {
                int n3 = i;
                dy[n3] = dy[n3] + da * dx[i];
                int n4 = i + 1;
                dy[n4] = dy[n4] + da * dx[i + 1];
                int n5 = i + 2;
                dy[n5] = dy[n5] + da * dx[i + 2];
                int n6 = i + 3;
                dy[n6] = dy[n6] + da * dx[i + 3];
                i += 4;
            }
            return;
        }
        int ix = 1;
        int iy = 1;
        if (incx < 0) {
            ix = (-n + 1) * incx + 1;
        }
        if (incy < 0) {
            iy = (-n + 1) * incy + 1;
        }
        int i = 1;
        while (i <= n) {
            int n7 = iy;
            dy[n7] = dy[n7] + da * dx[ix];
            ix += incx;
            iy += incy;
            ++i;
        }
    }

    public static double ddot_f77(int n, double[] dx, int incx, double[] dy, int incy) {
        double ddot = 0.0;
        if (n <= 0) {
            return ddot;
        }
        if (incx == 1 && incy == 1) {
            int m = n % 5;
            int i = 1;
            while (i <= m) {
                ddot += dx[i] * dy[i];
                ++i;
            }
            i = m + 1;
            while (i <= n) {
                ddot += dx[i] * dy[i] + dx[i + 1] * dy[i + 1] + dx[i + 2] * dy[i + 2] + dx[i + 3] * dy[i + 3] + dx[i + 4] * dy[i + 4];
                i += 5;
            }
            return ddot;
        }
        int ix = 1;
        int iy = 1;
        if (incx < 0) {
            ix = (-n + 1) * incx + 1;
        }
        if (incy < 0) {
            iy = (-n + 1) * incy + 1;
        }
        int i = 1;
        while (i <= n) {
            ddot += dx[ix] * dy[iy];
            ix += incx;
            iy += incy;
            ++i;
        }
        return ddot;
    }

    public static void dscal_f77(int n, double da, double[] dx, int incx) {
        if (n <= 0 || incx <= 0) {
            return;
        }
        if (incx == 1) {
            int m = n % 5;
            int i = 1;
            while (i <= m) {
                int n2 = i++;
                dx[n2] = dx[n2] * da;
            }
            i = m + 1;
            while (i <= n) {
                int n3 = i;
                dx[n3] = dx[n3] * da;
                int n4 = i + 1;
                dx[n4] = dx[n4] * da;
                int n5 = i + 2;
                dx[n5] = dx[n5] * da;
                int n6 = i + 3;
                dx[n6] = dx[n6] * da;
                int n7 = i + 4;
                dx[n7] = dx[n7] * da;
                i += 5;
            }
            return;
        }
        int nincx = n * incx;
        int i = 1;
        while (i <= nincx) {
            int n8 = i;
            dx[n8] = dx[n8] * da;
            i += incx;
        }
    }

    public static void dswap_f77(int n, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0) {
            return;
        }
        if (incx == 1 && incy == 1) {
            double dtemp;
            int m = n % 3;
            int i = 1;
            while (i <= m) {
                dtemp = dx[i];
                dx[i] = dy[i];
                dy[i] = dtemp;
                ++i;
            }
            i = m + 1;
            while (i <= n) {
                dtemp = dx[i];
                dx[i] = dy[i];
                dy[i] = dtemp;
                dtemp = dx[i + 1];
                dx[i + 1] = dy[i + 1];
                dy[i + 1] = dtemp;
                dtemp = dx[i + 2];
                dx[i + 2] = dy[i + 2];
                dy[i + 2] = dtemp;
                i += 3;
            }
            return;
        }
        int ix = 1;
        int iy = 1;
        if (incx < 0) {
            ix = (-n + 1) * incx + 1;
        }
        if (incy < 0) {
            iy = (-n + 1) * incy + 1;
        }
        int i = 1;
        while (i <= n) {
            double dtemp = dx[ix];
            dx[ix] = dy[iy];
            dy[iy] = dtemp;
            ix += incx;
            iy += incy;
            ++i;
        }
    }

    public static double dnrm2_f77(int n, double[] x, int incx) {
        double norm;
        if (n < 1 || incx < 1) {
            norm = 0.0;
        } else if (n == 1) {
            norm = Math.abs(x[1]);
        } else {
            double scale = 0.0;
            double ssq = 1.0;
            int limit = 1 + (n - 1) * incx;
            int ix = 1;
            while (ix <= limit) {
                if (x[ix] != 0.0) {
                    double fac;
                    double absxi = Math.abs(x[ix]);
                    if (scale < absxi) {
                        fac = scale / absxi;
                        ssq = 1.0 + ssq * fac * fac;
                        scale = absxi;
                    } else {
                        fac = absxi / scale;
                        ssq += fac * fac;
                    }
                }
                ix += incx;
            }
            norm = scale * Math.sqrt(ssq);
        }
        return norm;
    }

    public static void dcopy_f77(int n, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0) {
            return;
        }
        if (incx == 1 && incy == 1) {
            int m = n % 7;
            int i = 1;
            while (i <= m) {
                dy[i] = dx[i];
                ++i;
            }
            i = m + 1;
            while (i <= n) {
                dy[i] = dx[i];
                dy[i + 1] = dx[i + 1];
                dy[i + 2] = dx[i + 2];
                dy[i + 3] = dx[i + 3];
                dy[i + 4] = dx[i + 4];
                dy[i + 5] = dx[i + 5];
                dy[i + 6] = dx[i + 6];
                i += 7;
            }
            return;
        }
        int ix = 1;
        int iy = 1;
        if (incx < 0) {
            ix = (-n + 1) * incx + 1;
        }
        if (incy < 0) {
            iy = (-n + 1) * incy + 1;
        }
        int i = 1;
        while (i <= n) {
            dy[iy] = dx[ix];
            ix += incx;
            iy += incy;
            ++i;
        }
    }

    public static void drotg_f77(double[] rotvec) {
        double z;
        double s;
        double c;
        double r;
        double scale;
        double b;
        double a = rotvec[1];
        double roe = b = rotvec[2];
        if (Math.abs(a) > Math.abs(b)) {
            roe = a;
        }
        if ((scale = Math.abs(a) + Math.abs(b)) != 0.0) {
            double ra = a / scale;
            double rb = b / scale;
            r = scale * Math.sqrt(ra * ra + rb * rb);
            r = Blas_f77.sign_f77(1.0, roe) * r;
            c = a / r;
            s = b / r;
            z = 1.0;
            if (Math.abs(a) > Math.abs(b)) {
                z = s;
            }
            if (Math.abs(b) >= Math.abs(a) && c != 0.0) {
                z = 1.0 / c;
            }
        } else {
            c = 1.0;
            s = 0.0;
            r = 0.0;
            z = 0.0;
        }
        a = r;
        b = z;
        rotvec[1] = a;
        rotvec[2] = b;
        rotvec[3] = c;
        rotvec[4] = s;
    }

    public static void colaxpy_f77(int nrow, double a, double[][] x, int begin, int j1, int j2) {
        if (nrow <= 0) {
            return;
        }
        if (a == 0.0) {
            return;
        }
        int m = nrow % 4;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            double[] dArray = x[i];
            int n = j2;
            dArray[n] = dArray[n] + a * x[i][j1];
            ++i;
        }
        i = mpbegin;
        while (i <= end) {
            double[] dArray = x[i];
            int n = j2;
            dArray[n] = dArray[n] + a * x[i][j1];
            double[] dArray2 = x[i + 1];
            int n2 = j2;
            dArray2[n2] = dArray2[n2] + a * x[i + 1][j1];
            double[] dArray3 = x[i + 2];
            int n3 = j2;
            dArray3[n3] = dArray3[n3] + a * x[i + 2][j1];
            double[] dArray4 = x[i + 3];
            int n4 = j2;
            dArray4[n4] = dArray4[n4] + a * x[i + 3][j1];
            i += 4;
        }
    }

    public static void colvaxpy_f77(int nrow, double a, double[][] x, double[] y, int begin, int j) {
        if (nrow <= 0) {
            return;
        }
        if (a == 0.0) {
            return;
        }
        int m = nrow % 4;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            int n = i;
            y[n] = y[n] + a * x[i][j];
            ++i;
        }
        i = mpbegin;
        while (i <= end) {
            int n = i;
            y[n] = y[n] + a * x[i][j];
            int n2 = i + 1;
            y[n2] = y[n2] + a * x[i + 1][j];
            int n3 = i + 2;
            y[n3] = y[n3] + a * x[i + 2][j];
            int n4 = i + 3;
            y[n4] = y[n4] + a * x[i + 3][j];
            i += 4;
        }
    }

    public static void colvraxpy_f77(int nrow, double a, double[] y, double[][] x, int begin, int j) {
        if (nrow <= 0) {
            return;
        }
        if (a == 0.0) {
            return;
        }
        int m = nrow % 4;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            double[] dArray = x[i];
            int n = j;
            dArray[n] = dArray[n] + a * y[i];
            ++i;
        }
        i = mpbegin;
        while (i <= end) {
            double[] dArray = x[i];
            int n = j;
            dArray[n] = dArray[n] + a * y[i];
            double[] dArray2 = x[i + 1];
            int n2 = j;
            dArray2[n2] = dArray2[n2] + a * y[i + 1];
            double[] dArray3 = x[i + 2];
            int n3 = j;
            dArray3[n3] = dArray3[n3] + a * y[i + 2];
            double[] dArray4 = x[i + 3];
            int n4 = j;
            dArray4[n4] = dArray4[n4] + a * y[i + 3];
            i += 4;
        }
    }

    public static double coldot_f77(int nrow, double[][] x, int begin, int j1, int j2) {
        double coldot = 0.0;
        if (nrow <= 0) {
            return coldot;
        }
        int m = nrow % 5;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            coldot += x[i][j1] * x[i][j2];
            ++i;
        }
        i = mpbegin;
        while (i <= end) {
            coldot += x[i][j1] * x[i][j2] + x[i + 1][j1] * x[i + 1][j2] + x[i + 2][j1] * x[i + 2][j2] + x[i + 3][j1] * x[i + 3][j2] + x[i + 4][j1] * x[i + 4][j2];
            i += 5;
        }
        return coldot;
    }

    public static double colvdot_f77(int nrow, double[][] x, double[] y, int begin, int j) {
        double colvdot = 0.0;
        if (nrow <= 0) {
            return colvdot;
        }
        int m = nrow % 5;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            colvdot += x[i][j] * y[i];
            ++i;
        }
        i = mpbegin;
        while (i <= end) {
            colvdot += x[i][j] * y[i] + x[i + 1][j] * y[i + 1] + x[i + 2][j] * y[i + 2] + x[i + 3][j] * y[i + 3] + x[i + 4][j] * y[i + 4];
            i += 5;
        }
        return colvdot;
    }

    public static void colscal_f77(int nrow, double a, double[][] x, int begin, int j) {
        if (nrow <= 0) {
            return;
        }
        int m = nrow % 5;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            double[] dArray = x[i];
            int n = j;
            dArray[n] = dArray[n] * a;
            ++i;
        }
        i = mpbegin;
        while (i <= end) {
            double[] dArray = x[i];
            int n = j;
            dArray[n] = dArray[n] * a;
            double[] dArray2 = x[i + 1];
            int n2 = j;
            dArray2[n2] = dArray2[n2] * a;
            double[] dArray3 = x[i + 2];
            int n3 = j;
            dArray3[n3] = dArray3[n3] * a;
            double[] dArray4 = x[i + 3];
            int n4 = j;
            dArray4[n4] = dArray4[n4] * a;
            double[] dArray5 = x[i + 4];
            int n5 = j;
            dArray5[n5] = dArray5[n5] * a;
            i += 5;
        }
    }

    public static void dscalp_f77(int nrow, double a, double[] x, int begin) {
        if (nrow <= 0) {
            return;
        }
        int m = nrow % 5;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            int n = i++;
            x[n] = x[n] * a;
        }
        i = mpbegin;
        while (i <= end) {
            int n = i;
            x[n] = x[n] * a;
            int n2 = i + 1;
            x[n2] = x[n2] * a;
            int n3 = i + 2;
            x[n3] = x[n3] * a;
            int n4 = i + 3;
            x[n4] = x[n4] * a;
            int n5 = i + 4;
            x[n5] = x[n5] * a;
            i += 5;
        }
    }

    public static void colswap_f77(int n, double[][] x, int j1, int j2) {
        double temp;
        if (n <= 0) {
            return;
        }
        int m = n % 3;
        int i = 1;
        while (i <= m) {
            temp = x[i][j1];
            x[i][j1] = x[i][j2];
            x[i][j2] = temp;
            ++i;
        }
        i = m + 1;
        while (i <= n) {
            temp = x[i][j1];
            x[i][j1] = x[i][j2];
            x[i][j2] = temp;
            temp = x[i + 1][j1];
            x[i + 1][j1] = x[i + 1][j2];
            x[i + 1][j2] = temp;
            temp = x[i + 2][j1];
            x[i + 2][j1] = x[i + 2][j2];
            x[i + 2][j2] = temp;
            i += 3;
        }
    }

    public static double colnrm2_f77(int nrow, double[][] x, int begin, int j) {
        double norm;
        if (nrow < 1) {
            norm = 0.0;
        } else if (nrow == 1) {
            norm = Math.abs(x[begin][j]);
        } else {
            double scale = 0.0;
            double ssq = 1.0;
            int end = begin + nrow - 1;
            int i = begin;
            while (i <= end) {
                if (x[i][j] != 0.0) {
                    double fac;
                    double absxij = Math.abs(x[i][j]);
                    if (scale < absxij) {
                        fac = scale / absxij;
                        ssq = 1.0 + ssq * fac * fac;
                        scale = absxij;
                    } else {
                        fac = absxij / scale;
                        ssq += fac * fac;
                    }
                }
                ++i;
            }
            norm = scale * Math.sqrt(ssq);
        }
        return norm;
    }

    public static double dnrm2p_f77(int nrow, double[] x, int begin) {
        double norm;
        if (nrow < 1) {
            norm = 0.0;
        } else if (nrow == 1) {
            norm = Math.abs(x[begin]);
        } else {
            double scale = 0.0;
            double ssq = 1.0;
            int end = begin + nrow - 1;
            int i = begin;
            while (i <= end) {
                if (x[i] != 0.0) {
                    double fac;
                    double absxi = Math.abs(x[i]);
                    if (scale < absxi) {
                        fac = scale / absxi;
                        ssq = 1.0 + ssq * fac * fac;
                        scale = absxi;
                    } else {
                        fac = absxi / scale;
                        ssq += fac * fac;
                    }
                }
                ++i;
            }
            norm = scale * Math.sqrt(ssq);
        }
        return norm;
    }

    public static void dcopyp_f77(int nrow, double[] x, double[] y, int begin) {
        int m = nrow % 7;
        int mpbegin = m + begin;
        int end = begin + nrow - 1;
        int i = begin;
        while (i < mpbegin) {
            y[i] = x[i];
            ++i;
        }
        i = mpbegin;
        while (i <= end) {
            y[i] = x[i];
            y[i + 1] = x[i + 1];
            y[i + 2] = x[i + 2];
            y[i + 3] = x[i + 3];
            y[i + 4] = x[i + 4];
            y[i + 5] = x[i + 5];
            y[i + 6] = x[i + 6];
            i += 7;
        }
    }

    public static void colrot_f77(int n, double[][] x, int j1, int j2, double c, double s) {
        if (n <= 0) {
            return;
        }
        int i = 1;
        while (i <= n) {
            double temp = c * x[i][j1] + s * x[i][j2];
            x[i][j2] = c * x[i][j2] - s * x[i][j1];
            x[i][j1] = temp;
            ++i;
        }
    }

    public static double sign_f77(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }

    public static void matmat_f77(double[][] a, double[][] b, double[][] c, int n, int p, int r) {
        int i = 1;
        while (i <= n) {
            int j = 1;
            while (j <= r) {
                double vdot = 0.0;
                int m = p % 5;
                int k = 1;
                while (k <= m) {
                    vdot += a[i][k] * b[k][j];
                    ++k;
                }
                k = m + 1;
                while (k <= p) {
                    vdot += a[i][k] * b[k][j] + a[i][k + 1] * b[k + 1][j] + a[i][k + 2] * b[k + 2][j] + a[i][k + 3] * b[k + 3][j] + a[i][k + 4] * b[k + 4][j];
                    k += 5;
                }
                c[i][j] = vdot;
                ++j;
            }
            ++i;
        }
    }

    public static void mattran_f77(double[][] a, double[][] at, int n, int p) {
        int i = 1;
        while (i <= n) {
            int j = 1;
            while (j <= p) {
                at[j][i] = a[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static void matvec_f77(double[][] a, double[] b, double[] c, int n, int p) {
        int i = 1;
        while (i <= n) {
            double vdot = 0.0;
            int m = p % 5;
            int j = 1;
            while (j <= m) {
                vdot += a[i][j] * b[j];
                ++j;
            }
            j = m + 1;
            while (j <= p) {
                vdot += a[i][j] * b[j] + a[i][j + 1] * b[j + 1] + a[i][j + 2] * b[j + 2] + a[i][j + 3] * b[j + 3] + a[i][j + 4] * b[j + 4];
                j += 5;
            }
            c[i] = vdot;
            ++i;
        }
    }
}

