/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.datatype.GeneralizedCodons;

public class CodonAlignment
extends AbstractAlignment {
    public static final GeneralizedCodons DEFAULT_CODON_TRANSLATOR = new GeneralizedCodons();
    private char[][] data_;

    public CodonAlignment(Alignment raw) {
        this(raw, 0);
    }

    public CodonAlignment(Alignment raw, int startingCodonPosition) {
        this(raw, startingCodonPosition, DEFAULT_CODON_TRANSLATOR);
    }

    public CodonAlignment(Alignment raw, int startingCodonPosition, GeneralizedCodons trans) {
        this.numSeqs = raw.getSequenceCount();
        this.idGroup = raw;
        this.numSites = (raw.getSiteCount() - startingCodonPosition) / 3;
        this.dataType = new GeneralizedCodons();
        this.data_ = new char[this.numSeqs][this.numSites];
        this.constructData(raw, startingCodonPosition, trans);
    }

    private void constructData(Alignment raw, int startingCodonPosition, GeneralizedCodons trans) {
        int i = 0;
        while (i < this.numSeqs) {
            int j = 0;
            while (j < this.numSites) {
                char[] cs = new char[3];
                int k = 0;
                while (k < 3) {
                    cs[k] = raw.getData(i, j * 3 + startingCodonPosition + k);
                    ++k;
                }
                this.data_[i][j] = trans.getCodonCharFromCodon(cs);
                ++j;
            }
            ++i;
        }
    }

    public char getData(int seq, int site) {
        return this.data_[seq][site];
    }
}

