/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.util.Vector;
import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.alignment.IndelPosition;
import pal.datatype.NumericDataType;
import pal.misc.IdGroup;
import pal.misc.SimpleIdGroup;

public class IndelAlignment
extends AbstractAlignment {
    String[] sequences;
    boolean anchored;
    Vector indel;
    private Alignment rawAlignment = null;

    public IndelAlignment(Alignment a, boolean anchored) {
        this.rawAlignment = a;
        this.anchored = anchored;
        this.dataType = new NumericDataType();
        this.sequences = new String[a.getIdCount()];
        this.findIndels();
        String gaps = '-' + "";
        this.init(new SimpleIdGroup(a), gaps);
    }

    private void findIndels() {
        this.indel = new Vector();
        StringBuffer[] tempSeq = new StringBuffer[this.rawAlignment.getSequenceCount()];
        int rawNumSites = this.rawAlignment.getSiteCount();
        int i = 0;
        while (i < this.rawAlignment.getSequenceCount()) {
            tempSeq[i] = new StringBuffer();
            ++i;
        }
        int j = 1;
        while (j < rawNumSites) {
            int i2 = 0;
            while (i2 < this.rawAlignment.getSequenceCount()) {
                if (this.rawAlignment.getData(i2, j) == '-' && this.rawAlignment.getData(i2, j - 1) != '-') {
                    int p = j + 1;
                    while (this.rawAlignment.getData(i2, p) == '-' && p < rawNumSites - 1) {
                        ++p;
                    }
                    IndelPosition currIndel = new IndelPosition(j, p - 1, this.anchored);
                    if (!this.indel.contains(currIndel)) {
                        this.indel.addElement(currIndel);
                        this.scoreIndelsInAllSequence(currIndel, tempSeq);
                    }
                }
                ++i2;
            }
            ++j;
        }
        NumericDataType theNumericDataType = new NumericDataType();
        int i3 = 0;
        while (i3 < this.sequences.length) {
            this.sequences[i3] = tempSeq[i3].toString();
            ++i3;
        }
    }

    private void scoreIndelsInAllSequence(IndelPosition currIndel, StringBuffer[] tempSeq) {
        int nSites = this.rawAlignment.getSiteCount() - 1;
        NumericDataType theNumericDataType = new NumericDataType();
        if (this.anchored) {
            int i = 0;
            while (i < this.rawAlignment.getSequenceCount()) {
                int j;
                int backwardSize = 0;
                int forwardSize = 0;
                if (this.rawAlignment.getData(i, currIndel.start - 1) != '-' && this.rawAlignment.getData(i, currIndel.start) == '-') {
                    j = currIndel.start;
                    while (this.rawAlignment.getData(i, j) == '-' && j < nSites) {
                        ++forwardSize;
                        ++j;
                    }
                    if (this.rawAlignment.getData(i, j) == '?') {
                        tempSeq[i].append('?');
                    } else {
                        tempSeq[i].append(theNumericDataType.getNumericCharFromNumericIndex(forwardSize));
                    }
                } else if (this.rawAlignment.getData(i, currIndel.end + 1) != '-' && this.rawAlignment.getData(i, currIndel.end) == '-') {
                    j = currIndel.end;
                    while (this.rawAlignment.getData(i, j) == '-' && j > 0) {
                        ++backwardSize;
                        --j;
                    }
                    if (this.rawAlignment.getData(i, j) == '?') {
                        tempSeq[i].append('?');
                    } else {
                        tempSeq[i].append(theNumericDataType.getNumericCharFromNumericIndex(backwardSize));
                    }
                } else if (this.rawAlignment.getData(i, currIndel.start - 1) == '-' || this.rawAlignment.getData(i, currIndel.end + 1) == '-' || this.rawAlignment.getData(i, currIndel.start) == '?' || this.rawAlignment.getData(i, currIndel.end) == '?') {
                    tempSeq[i].append('?');
                } else {
                    tempSeq[i].append(theNumericDataType.getNumericCharFromNumericIndex(0));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.rawAlignment.getSequenceCount()) {
                int backwardSize = 0;
                int forwardSize = 0;
                if (this.rawAlignment.getData(i, currIndel.start - 1) == '-' && this.rawAlignment.getData(i, currIndel.end + 1) == '-') {
                    tempSeq[i].append('?');
                } else {
                    int j = currIndel.start;
                    while (this.rawAlignment.getData(i, j) == '-' && j < nSites) {
                        ++forwardSize;
                        ++j;
                    }
                    if (this.rawAlignment.getData(i, j) == '?') {
                        tempSeq[i].append('?');
                    } else {
                        j = currIndel.end;
                        while (this.rawAlignment.getData(i, j) == '-' && j > 0) {
                            ++backwardSize;
                            --j;
                        }
                        if (this.rawAlignment.getData(i, j) == '?') {
                            tempSeq[i].append('?');
                        } else {
                            int size = forwardSize != backwardSize ? 0 : backwardSize;
                            tempSeq[i].append(theNumericDataType.getNumericCharFromNumericIndex(size));
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void init(IdGroup group, String gaps) {
        this.numSeqs = this.sequences.length;
        this.numSites = this.sequences[0].length();
        this.idGroup = group;
        AlignmentUtils.estimateFrequencies(this);
    }

    public char getData(int seq, int site) {
        return this.sequences[seq].charAt(site);
    }

    IndelPosition getIndelPosition(int i) {
        return (IndelPosition)this.indel.elementAt(i);
    }
}

