/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.math.UrnModel;
import pal.misc.SimpleIdGroup;

public class JumbledAlignment
extends AbstractAlignment {
    private UrnModel urn;
    private Alignment rawAlignment;
    private int[] alias;

    public JumbledAlignment(Alignment raw) {
        this.rawAlignment = raw;
        this.numSeqs = raw.getSequenceCount();
        this.numSites = raw.getSiteCount();
        this.idGroup = new SimpleIdGroup(this.numSeqs);
        this.alias = new int[this.numSeqs];
        this.urn = new UrnModel(this.numSeqs);
        this.jumble();
    }

    public char getData(int seq, int site) {
        return this.rawAlignment.getData(this.alias[seq], site);
    }

    public void jumble() {
        this.urn.reset();
        int i = 0;
        while (i < this.numSeqs) {
            this.alias[i] = this.urn.drawDontPutBack();
            this.idGroup.setIdentifier(i, this.rawAlignment.getIdentifier(this.alias[i]));
            ++i;
        }
    }
}

