/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.datatype.DataType;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;

public class SimpleAlignment
extends AbstractAlignment {
    String[] sequences;
    private static final long serialVersionUID = 4303224913340358191L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.sequences);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.sequences = (String[])in.readObject();
    }

    public SimpleAlignment() {
    }

    public SimpleAlignment(Alignment a) {
        String[] sequences = new String[a.getIdCount()];
        int i = 0;
        while (i < sequences.length) {
            sequences[i] = a.getAlignedSequenceString(i);
            ++i;
        }
        String gaps = '-' + "";
        this.init(new SimpleIdGroup(a), sequences, gaps);
    }

    public SimpleAlignment(Alignment a, int sequenceToIgnore) {
        int numberOfOriginalSequences = a.getIdCount();
        String[] sequences = sequenceToIgnore < 0 || sequenceToIgnore >= numberOfOriginalSequences ? new String[numberOfOriginalSequences] : new String[numberOfOriginalSequences - 1];
        int index = 0;
        int i = 0;
        while (i < numberOfOriginalSequences) {
            if (i != sequenceToIgnore) {
                sequences[index++] = a.getAlignedSequenceString(i);
            }
            ++i;
        }
        String gaps = '-' + "";
        this.init(new SimpleIdGroup((IdGroup)a, sequenceToIgnore), sequences, gaps);
    }

    public SimpleAlignment(Identifier[] ids, String[] sequences, String gaps) {
        this.init(new SimpleIdGroup(ids), sequences, gaps);
    }

    public SimpleAlignment(IdGroup group, String[] sequences) {
        this.init(group, sequences, null);
    }

    public SimpleAlignment(IdGroup group, String[] sequences, String gaps) {
        this.init(group, sequences, gaps);
    }

    public SimpleAlignment(IdGroup group, char[][] cSequences) {
        this(group, cSequences, null);
    }

    public SimpleAlignment(IdGroup group, char[][] cSequences, String gaps) {
        this(group, cSequences, gaps, null);
    }

    public SimpleAlignment(IdGroup group, char[][] cSequences, String gaps, DataType dataType_) {
        this.dataType = dataType_;
        String[] sequences = new String[cSequences.length];
        int i = 0;
        while (i < sequences.length) {
            sequences[i] = new String(cSequences[i]);
            ++i;
        }
        this.init(group, sequences, gaps);
        if (this.dataType == null) {
            this.dataType = AlignmentUtils.getSuitableInstance(this);
        }
    }

    private void init(IdGroup group, String[] sequences, String gaps) {
        this.numSeqs = sequences.length;
        this.numSites = sequences[0].length();
        this.sequences = sequences;
        this.idGroup = group;
        if (gaps != null) {
            this.convertGaps(gaps);
        }
        AlignmentUtils.estimateFrequencies(this);
    }

    public SimpleAlignment(Identifier id, String sequence, DataType dataType_) {
        this(id, sequence, dataType_, true);
    }

    public SimpleAlignment(Identifier id, String sequence, DataType dataType_, boolean estFreqs) {
        this.dataType = dataType_;
        this.numSeqs = 1;
        this.numSites = sequence.length();
        this.sequences = new String[1];
        this.sequences[0] = sequence;
        Identifier[] ids = new Identifier[]{id};
        this.idGroup = new SimpleIdGroup(ids);
        if (estFreqs) {
            AlignmentUtils.estimateFrequencies(this);
        }
    }

    public SimpleAlignment(Alignment a, Alignment b, String guide1, String guide2, char gap) {
        this.sequences = new String[a.getSequenceCount() + b.getSequenceCount()];
        this.numSeqs = this.sequences.length;
        int i = 0;
        while (i < a.getSequenceCount()) {
            this.sequences[i] = this.getAlignedString(a.getAlignedSequenceString(i), guide1, gap, '-');
            ++i;
        }
        int i2 = 0;
        while (i2 < b.getSequenceCount()) {
            this.sequences[i2 + a.getSequenceCount()] = this.getAlignedString(b.getAlignedSequenceString(i2), guide2, gap, '-');
            ++i2;
        }
        this.numSites = this.sequences[0].length();
        this.idGroup = new SimpleIdGroup((IdGroup)a, b);
        AlignmentUtils.estimateFrequencies(this);
    }

    public char getData(int seq, int site) {
        return this.sequences[seq].charAt(site);
    }

    public String getAlignedSequenceString(int seq) {
        return this.sequences[seq];
    }

    private String getAlignedString(String original, String guide, char guideChar, char gapChar) {
        StringBuffer buf = new StringBuffer(guide.length());
        int seqcounter = 0;
        int j = 0;
        while (j < guide.length()) {
            if (guide.charAt(j) != guideChar) {
                buf.append(original.charAt(seqcounter));
                ++seqcounter;
            } else {
                buf.append(gapChar);
            }
            ++j;
        }
        return new String(buf);
    }

    private void convertGaps(String gaps) {
        int i = 0;
        while (i < this.sequences.length) {
            int j = 0;
            while (j < gaps.length()) {
                this.sequences[i] = this.sequences[i].replace(gaps.charAt(j), '-');
                ++j;
            }
            ++i;
        }
    }

    static {
        serialVersionUID = 4303224913340358191L;
    }
}

