/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.coalescent.ConstantPopulation;
import pal.io.OutputTarget;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.Summarizable;

public class ExponentialGrowth
extends ConstantPopulation
implements Report,
Parameterized,
Serializable,
Summarizable {
    private static final String[] EG_SUMMARY_TYPES = new String[]{"N0", "N0SE", "R", "RSE"};
    public double r;
    public double rSE;

    public ExponentialGrowth(int units) {
        super(units);
        this.r = this.getDefaultValue(1);
    }

    public ExponentialGrowth(double size, double growth, int units) {
        super(size, units);
        this.r = growth;
    }

    public String[] getSummaryTypes() {
        return EG_SUMMARY_TYPES;
    }

    public double getSummaryValue(int summaryType) {
        switch (summaryType) {
            case 2: {
                return this.r;
            }
            case 3: {
                return this.rSE;
            }
        }
        return super.getSummaryValue(summaryType);
    }

    public Object clone() {
        return new ExponentialGrowth(this.getN0(), this.getGrowthRate(), this.getUnits());
    }

    public double getGrowthRate() {
        return this.r;
    }

    public double getDemographic(double t) {
        if (this.r == 0.0) {
            return this.N0;
        }
        return this.N0 * Math.exp(-t * this.r);
    }

    public double getIntensity(double t) {
        if (this.r == 0.0) {
            return t / this.N0;
        }
        return (Math.exp(t * this.r) - 1.0) / this.N0 / this.r;
    }

    public double getInverseIntensity(double x) {
        if (this.r == 0.0) {
            return this.N0 * x;
        }
        return Math.log(1.0 + this.N0 * x * this.r) / this.r;
    }

    public int getNumParameters() {
        return 2;
    }

    public double getParameter(int k) {
        if (k == 0) {
            return this.N0;
        }
        return this.r;
    }

    public double getUpperLimit(int k) {
        double max = 0.0;
        switch (k) {
            case 0: {
                max = 1.0E50;
                break;
            }
            case 1: {
                max = 1000.0;
                break;
            }
        }
        return max;
    }

    public double getLowerLimit(int k) {
        double min = 0.0;
        switch (k) {
            case 0: {
                min = 1.0E-12;
                break;
            }
            case 1: {
                min = -200.0;
                break;
            }
        }
        return min;
    }

    public double getDefaultValue(int k) {
        if (k == 0) {
            if (this.getUnits() == 1) {
                return 1000.0;
            }
            return 0.2;
        }
        return 0.0;
    }

    public void setParameter(double value, int k) {
        switch (k) {
            case 0: {
                this.N0 = value;
                break;
            }
            case 1: {
                this.r = value;
                break;
            }
        }
    }

    public void setParameterSE(double value, int k) {
        switch (k) {
            case 0: {
                this.N0SE = value;
                break;
            }
            case 1: {
                this.rSE = value;
                break;
            }
        }
    }

    public String toString() {
        OutputTarget out = OutputTarget.openString();
        this.report(out);
        out.close();
        return out.getString();
    }

    public void report(PrintWriter out) {
        out.println("Demographic model: exponential growth");
        out.println("Demographic function: N(t) = N0 exp(-r t)");
        out.print("Unit of time: ");
        if (this.getUnits() == 1) {
            out.print("generations");
        } else {
            out.print("expected substitutions");
        }
        out.println();
        out.println();
        out.println("Parameters of demographic function:");
        out.print(" present-day population size N0: ");
        this.fo.displayDecimal(out, this.N0, 6);
        if (this.N0SE != 0.0) {
            out.print(" (S.E. ");
            this.fo.displayDecimal(out, this.N0SE, 6);
            out.print(")");
        }
        out.println();
        out.print(" growth rate r: ");
        this.fo.displayDecimal(out, this.r, 6);
        if (this.rSE != 0.0) {
            out.print(" (S.E. ");
            this.fo.displayDecimal(out, this.rSE, 6);
            out.print(")");
        }
        out.println();
        if (this.getLogL() != 0.0) {
            out.println();
            out.print("log L: ");
            this.fo.displayDecimal(out, this.getLogL(), 6);
            out.println();
        }
    }
}

