/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.Serializable;
import pal.datatype.AminoAcids;
import pal.datatype.Codons;
import pal.datatype.DataType;
import pal.datatype.GeneralizedCodons;
import pal.datatype.IUPACNucleotides;
import pal.datatype.Nucleotides;
import pal.datatype.TwoStates;

public class DataTypeUtils
implements Serializable {
    public static DataType getInstance(int typeID) {
        if (typeID == 0) {
            return new Nucleotides();
        }
        if (typeID == 1) {
            return new AminoAcids();
        }
        if (typeID == 2) {
            return new TwoStates();
        }
        if (typeID == 3) {
            return new IUPACNucleotides();
        }
        if (typeID == 4) {
            return new Codons();
        }
        if (typeID == 5) {
            return GeneralizedCodons.DEFAULT_INSTANCE;
        }
        throw new IllegalArgumentException("typeID " + typeID + " is not recognised.");
    }

    public static final int[] getSequenceStates(DataType d, String sequence) {
        int[] states = new int[sequence.length()];
        int i = 0;
        while (i < sequence.length()) {
            states[i] = d.getState(sequence.charAt(i));
            ++i;
        }
        return states;
    }

    public static final boolean isGap(DataType d, char c) {
        return d.getState(c) == d.getNumStates();
    }

    public static final byte[] getByteStates(String sequence, DataType dt) {
        return DataTypeUtils.getByteStates(sequence.toCharArray(), dt);
    }

    public static final byte[] getByteStates(char[] sequence, DataType dt) {
        byte[] bs = new byte[sequence.length];
        int i = 0;
        while (i < bs.length) {
            bs[i] = (byte)dt.getState(sequence[i]);
            ++i;
        }
        return bs;
    }

    public static final int[][] getStates(char[][] sequences, DataType dt) {
        int[][] statesSeqs = new int[sequences.length][];
        int i = 0;
        while (i < statesSeqs.length) {
            statesSeqs[i] = DataTypeUtils.getStates(sequences[i], dt);
            ++i;
        }
        return statesSeqs;
    }

    public static final int[] getStates(char[] sequence, DataType dt) {
        int[] states = new int[sequence.length];
        int i = 0;
        while (i < states.length) {
            states[i] = dt.getState(sequence[i]);
            ++i;
        }
        return states;
    }

    public static final int[][] getStates(char[][] sequences, int unknownState, DataType dt) {
        int[][] statesSeqs = new int[sequences.length][];
        int i = 0;
        while (i < statesSeqs.length) {
            statesSeqs[i] = DataTypeUtils.getStates(sequences[i], unknownState, dt);
            ++i;
        }
        return statesSeqs;
    }

    public static final int[] getStates(char[] sequence, int unknownState, DataType dt) {
        int[] states = new int[sequence.length];
        int i = 0;
        while (i < states.length) {
            states[i] = dt.getState(sequence[i]);
            if (dt.isUnknownState(states[i])) {
                states[i] = unknownState;
            }
            ++i;
        }
        return states;
    }

    public static final char[][] getChars(int[][] sequences, char unknownChar, DataType dt) {
        char[][] charSeqs = new char[sequences.length][];
        int i = 0;
        while (i < charSeqs.length) {
            charSeqs[i] = DataTypeUtils.getChars(sequences[i], unknownChar, dt);
            ++i;
        }
        return charSeqs;
    }

    public static final char[] getChars(int[] sequence, char unknownChar, DataType dt) {
        char[] chars = new char[sequence.length];
        int i = 0;
        while (i < chars.length) {
            chars[i] = dt.isUnknownState(sequence[i]) ? unknownChar : dt.getChar(sequence[i]);
            ++i;
        }
        return chars;
    }
}

