/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.Serializable;
import pal.datatype.DataType;
import pal.datatype.Nucleotides;
import pal.datatype.SimpleDataType;
import pal.math.MathUtils;

public class GeneralizedCodons
extends SimpleDataType
implements Serializable {
    private static final int BASE_CHARACTER_INDEX = 64;
    public static final GeneralizedCodons DEFAULT_INSTANCE;
    DataType characterType_ = null;
    int numberOfCharacterStates_ = -1;
    int codonLength_;
    int numberOfCodonStates_;

    public GeneralizedCodons() {
        this(new Nucleotides(), 3);
    }

    public GeneralizedCodons(DataType characterType, int codonLength) {
        this.characterType_ = characterType;
        this.numberOfCharacterStates_ = this.characterType_.getNumStates();
        this.codonLength_ = codonLength;
        this.numberOfCodonStates_ = 1;
        int i = 0;
        while (i < this.codonLength_) {
            this.numberOfCodonStates_ *= this.numberOfCharacterStates_;
            ++i;
        }
    }

    public final int getCodonIndexFromCodon(char[] codon) {
        if (codon.length < this.codonLength_) {
            return -1;
        }
        int index = 0;
        int i = 0;
        while (i < this.codonLength_) {
            index *= this.numberOfCharacterStates_;
            int state = this.characterType_.getState(codon[i]);
            if (state >= this.numberOfCharacterStates_) {
                return -1;
            }
            index += state;
            ++i;
        }
        return index;
    }

    public final int getCodonIndexFromCodonStates(int[] codon) {
        if (codon.length < this.codonLength_) {
            return -1;
        }
        int index = 0;
        int i = 0;
        while (i < this.codonLength_) {
            index *= this.numberOfCharacterStates_;
            int state = codon[i];
            if (state >= this.numberOfCharacterStates_ || state < 0) {
                return -1;
            }
            index += state;
            ++i;
        }
        return index;
    }

    public final char[] getCodonFromCodonIndex(int index) {
        char[] cs = new char[this.codonLength_];
        int i = this.codonLength_ - 1;
        while (i >= 0) {
            cs[i] = this.characterType_.getChar(index % this.numberOfCharacterStates_);
            index /= this.numberOfCharacterStates_;
            --i;
        }
        return cs;
    }

    public final char[] getCodonFromCodonChar(char codonChar) {
        int index = codonChar - 64;
        char[] cs = new char[this.codonLength_];
        int i = this.codonLength_ - 1;
        while (i >= 0) {
            cs[i] = this.characterType_.getChar(index % this.numberOfCharacterStates_);
            index /= this.numberOfCharacterStates_;
            --i;
        }
        return cs;
    }

    public final int[] getBaseStatesFromCodonState(int codonState) {
        int[] cs = new int[this.codonLength_];
        int i = this.codonLength_ - 1;
        while (i >= 0) {
            cs[i] = codonState % this.numberOfCharacterStates_;
            codonState /= this.numberOfCharacterStates_;
            --i;
        }
        return cs;
    }

    public final char getCodonCharFromCodonIndex(int index) {
        return (char)(index + 64);
    }

    public final int getCodonIndexFromCodonChar(char c) {
        return c - 64;
    }

    public final char getCodonCharFromCodon(char[] codon) {
        return this.getCodonCharFromCodonIndex(this.getCodonIndexFromCodon(codon));
    }

    public final char getCodonCharFromCodonStates(int[] codon) {
        return this.getCodonCharFromCodonIndex(this.getCodonIndexFromCodonStates(codon));
    }

    public final String convertNucleotideToCodon(String nucleotideSequence, int startingPosition, int length, boolean reverse) {
        return this.convertNucleotideToCodon(nucleotideSequence.toCharArray(), startingPosition, length, reverse).toString();
    }

    public final char[] convertNucleotideToCodon(char[] nucleotideSequence, int startingPosition, int length, boolean reverse) {
        char[] work = new char[this.codonLength_];
        int numberOfCodons = length / this.codonLength_;
        char[] aas = new char[numberOfCodons];
        if (reverse) {
            int i = 0;
            while (i < numberOfCodons) {
                int index = i * this.codonLength_ + startingPosition;
                int j = 0;
                while (j < this.codonLength_) {
                    work[j] = nucleotideSequence[(index + this.codonLength_ - 1 - j) % nucleotideSequence.length];
                    ++j;
                }
                aas[numberOfCodons - i - 1] = this.getCodonCharFromCodon(work);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numberOfCodons) {
                int index = i * this.codonLength_ + startingPosition;
                int j = 0;
                while (j < this.codonLength_) {
                    work[j] = nucleotideSequence[(index + j) % nucleotideSequence.length];
                    ++j;
                }
                aas[i] = this.getCodonCharFromCodon(work);
                ++i;
            }
        }
        return aas;
    }

    public int getNumStates() {
        return this.numberOfCodonStates_;
    }

    public int getState(char c) {
        if (c == '?') {
            return this.numberOfCodonStates_;
        }
        return this.getCodonIndexFromCodonChar(c);
    }

    public char getChar(int state) {
        if (state >= this.numberOfCodonStates_) {
            return '?';
        }
        return this.getCodonCharFromCodonIndex(state);
    }

    public String getDescription() {
        return "Codon";
    }

    public boolean isUnknownState(int state) {
        return state >= this.numberOfCodonStates_ || state < 0;
    }

    public int getTypeID() {
        return 5;
    }

    public double[] getCodonFrequencies(double[] residueFrequencies) {
        residueFrequencies = MathUtils.getNormalized(residueFrequencies);
        double[] codonFreqs = new double[this.numberOfCodonStates_];
        int j = 0;
        while (j < this.numberOfCodonStates_) {
            int index = j;
            double prob = 1.0;
            int i = this.codonLength_ - 1;
            while (i >= 0) {
                prob *= residueFrequencies[index % this.numberOfCharacterStates_];
                index /= this.numberOfCharacterStates_;
                --i;
            }
            codonFreqs[j] = prob;
            ++j;
        }
        return MathUtils.getNormalized(codonFreqs);
    }

    public final double[] getNucleotideFrequencies(double[] codonFrequencies) {
        double[] result = new double[this.numberOfCharacterStates_];
        int numCodons = this.getNumStates();
        int i = 0;
        while (i < this.numberOfCharacterStates_) {
            char c = this.characterType_.getChar(i);
            result[i] = 0.0;
            int codonNumber = 0;
            while (codonNumber < numCodons) {
                int numberOfNucleotideOccurances = 0;
                char[] codon = this.getCodonFromCodonIndex(codonNumber);
                int j = 0;
                while (j < codon.length) {
                    if (codon[j] == c) {
                        ++numberOfNucleotideOccurances;
                    }
                    ++j;
                }
                int n = i;
                result[n] = result[n] + codonFrequencies[codonNumber] * (double)numberOfNucleotideOccurances;
                ++codonNumber;
            }
            ++i;
        }
        return MathUtils.getNormalized(result);
    }

    static {
        BASE_CHARACTER_INDEX = 64;
        DEFAULT_INSTANCE = new GeneralizedCodons();
    }
}

