/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.datatype.SimpleDataType;

public class Nucleotides
extends SimpleDataType {
    public static final int A_STATE = 0;
    public static final int C_STATE = 1;
    public static final int G_STATE = 2;
    public static final int UT_STATE = 3;
    private static final long serialVersionUID = -497943046234232204L;
    boolean isRNA_;
    private static final char[] DNA_CONVERASION_TABLE;
    private static final char[] RNA_CONVERASION_TABLE;
    public static final Nucleotides DEFAULT_INSTANCE;
    char[] conversionTable_ = DNA_CONVERASION_TABLE;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeBoolean(this.isRNA_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.isRNA_ = in.readBoolean();
        this.conversionTable_ = this.isRNA_ ? RNA_CONVERASION_TABLE : DNA_CONVERASION_TABLE;
    }

    public Nucleotides() {
        this(false);
    }

    public Nucleotides(boolean isRNA) {
        this.isRNA_ = isRNA;
        char[] cArray = this.conversionTable_ = this.isRNA_ ? RNA_CONVERASION_TABLE : DNA_CONVERASION_TABLE;
        if (this.conversionTable_ == null) {
            char[] defaultTable = new char[]{'A', 'C', 'G', 'T', '?'};
            if (this.isRNA_) {
                defaultTable[0] = 85;
            }
            this.conversionTable_ = defaultTable;
        }
    }

    public int getNumStates() {
        return 4;
    }

    public boolean isUnknownState(int state) {
        return state >= 4 || state < 0;
    }

    public int getState(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'U': {
                return 3;
            }
            case '?': {
                return 4;
            }
        }
        return 4;
    }

    public char getChar(int state) {
        if (state < this.conversionTable_.length && state >= 0) {
            return this.conversionTable_[state];
        }
        return '?';
    }

    public String getDescription() {
        return "nucleotide";
    }

    public int getTypeID() {
        return 0;
    }

    public final boolean isTransistionByState(int firstState, int secondState) {
        switch (firstState) {
            case 0: {
                return secondState == 2;
            }
            case 1: {
                return secondState == 3;
            }
            case 2: {
                return secondState == 0;
            }
            case 3: {
                return secondState == 1;
            }
        }
        return false;
    }

    public final boolean isTransistionByChar(char firstChar, char secondChar) {
        return this.isTransistionByState(this.getState(firstChar), this.getState(secondChar));
    }

    static {
        A_STATE = 0;
        C_STATE = 1;
        G_STATE = 2;
        UT_STATE = 3;
        serialVersionUID = -497943046234232204L;
        DNA_CONVERASION_TABLE = new char[]{'A', 'C', 'G', 'T', '?'};
        RNA_CONVERASION_TABLE = new char[]{'A', 'C', 'G', 'T', '?'};
        DEFAULT_INSTANCE = new Nucleotides();
    }
}

