/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.Serializable;
import pal.datatype.DataType;
import pal.datatype.SimpleDataType;

public class StateRemover
extends SimpleDataType
implements Serializable {
    DataType toAdjust_;
    int[] originalToAdjusted_;
    int[] adjustedToOriginal_;

    public StateRemover(DataType toAdjust, int[] statesToRemove) {
        this.toAdjust_ = toAdjust;
        this.createTranslationTables(toAdjust.getNumStates(), statesToRemove);
    }

    private final void createTranslationTables(int numberOfOriginalStates, int[] statesToRemove) {
        this.originalToAdjusted_ = new int[numberOfOriginalStates];
        this.adjustedToOriginal_ = new int[numberOfOriginalStates - statesToRemove.length];
        int currentAdjustedState = 0;
        int i = 0;
        while (i < numberOfOriginalStates) {
            boolean removeState = false;
            int j = 0;
            while (j < statesToRemove.length) {
                if (statesToRemove[j] == i) {
                    removeState = true;
                    break;
                }
                ++j;
            }
            if (removeState) {
                this.originalToAdjusted_[i] = this.adjustedToOriginal_.length;
            } else {
                this.originalToAdjusted_[i] = currentAdjustedState;
                this.adjustedToOriginal_[currentAdjustedState] = i;
                ++currentAdjustedState;
            }
            ++i;
        }
    }

    public int getNumStates() {
        return this.adjustedToOriginal_.length;
    }

    public boolean isUnknownState(int state) {
        return state >= this.adjustedToOriginal_.length || state < 0;
    }

    public int getState(char c) {
        int unadjustedState = this.toAdjust_.getState(c);
        if (!this.toAdjust_.isUnknownState(unadjustedState)) {
            return this.originalToAdjusted_[unadjustedState];
        }
        return this.adjustedToOriginal_.length;
    }

    public char getChar(int state) {
        if (state > this.adjustedToOriginal_.length) {
            return '?';
        }
        return this.toAdjust_.getChar(this.adjustedToOriginal_[state]);
    }

    public String getDescription() {
        return this.toAdjust_.getDescription() + " with states removed";
    }

    public int getTypeID() {
        return this.toAdjust_.getTypeID();
    }
}

