/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.AminoAcids;
import pal.datatype.CodonTable;
import pal.datatype.DataType;
import pal.datatype.GeneralizedCodons;
import pal.datatype.Nucleotides;

class UniversalTranslator
implements CodonTable {
    int[] translations_ = new int[64];
    int[] terminatorIndexes_ = null;
    DataType aminoAcids_ = AminoAcids.DEFAULT_INSTANCE;
    DataType nucleotides_ = Nucleotides.DEFAULT_INSTANCE;
    GeneralizedCodons generalizedCodons_ = GeneralizedCodons.DEFAULT_INSTANCE;

    private void addTerminalIndex(int index) {
        int[] ts = new int[this.terminatorIndexes_.length + 1];
        int i = 0;
        while (i < this.terminatorIndexes_.length) {
            ts[i] = this.terminatorIndexes_[i];
            ++i;
        }
        ts[ts.length - 1] = index;
        this.terminatorIndexes_ = ts;
    }

    private void removeTerminalIndex(int index) {
        int[] ts = new int[this.terminatorIndexes_.length - 1];
        int toAddIndex = 0;
        int i = 0;
        while (i < this.terminatorIndexes_.length) {
            if (index != this.terminatorIndexes_[i]) {
                ts[toAddIndex] = this.terminatorIndexes_[i];
                ++toAddIndex;
            }
            ++i;
        }
    }

    public final char[][] getCodonsFromAminoAcidChar(char aminoAcidChar) {
        return this.getCodonsFromAminoAcidState(this.aminoAcids_.getState(aminoAcidChar));
    }

    public final char[][] getCodonsFromAminoAcidState(int aminoAcid) {
        int count = 0;
        int i = 0;
        while (i < this.translations_.length) {
            if (this.translations_[i] == aminoAcid) {
                ++count;
            }
            ++i;
        }
        char[][] results = new char[count][];
        count = 0;
        int i2 = 0;
        while (i2 < this.translations_.length) {
            if (this.translations_[i2] == aminoAcid) {
                results[count] = this.generalizedCodons_.getCodonFromCodonIndex(i2);
                ++count;
            }
            ++i2;
        }
        return results;
    }

    protected void add(String codon, char aminoAcid) {
        int index = this.generalizedCodons_.getCodonIndexFromCodon(codon.toCharArray());
        if (index < 0) {
            throw new RuntimeException("Assertion error: Adding invalid Codon:" + codon);
        }
        if (aminoAcid != '*') {
            if (this.translations_[index] == 21) {
                this.removeTerminalIndex(index);
            }
        } else {
            this.addTerminalIndex(index);
        }
        this.translations_[index] = this.aminoAcids_.getState(aminoAcid);
    }

    public char getAminoAcidChar(char[] codon) {
        return this.aminoAcids_.getChar(this.getAminoAcidState(codon));
    }

    public int getAminoAcidState(char[] codon) {
        int index = this.generalizedCodons_.getCodonIndexFromCodon(codon);
        if (index < 0) {
            return this.aminoAcids_.getState('?');
        }
        return this.translations_[index];
    }

    public char getAminoAcidCharFromCodonIndex(int codonIndex) {
        return this.aminoAcids_.getChar(this.getAminoAcidStateFromCodonIndex(codonIndex));
    }

    public int getAminoAcidStateFromCodonIndex(int codonIndex) {
        return this.translations_[codonIndex];
    }

    private void clearTranslationTables() {
        int i = 0;
        while (i < this.translations_.length) {
            this.translations_[i] = -1;
            ++i;
        }
        this.terminatorIndexes_ = new int[0];
    }

    public UniversalTranslator() {
        this.clearTranslationTables();
        this.add("UUU", 'F');
        this.add("UUC", 'F');
        this.add("UUA", 'L');
        this.add("UUG", 'L');
        this.add("CUU", 'L');
        this.add("CUC", 'L');
        this.add("CUA", 'L');
        this.add("CUG", 'L');
        this.add("AUU", 'I');
        this.add("AUC", 'I');
        this.add("AUA", 'I');
        this.add("AUG", 'M');
        this.add("GUU", 'V');
        this.add("GUC", 'V');
        this.add("GUA", 'V');
        this.add("GUG", 'V');
        this.add("UCU", 'S');
        this.add("UCC", 'S');
        this.add("UCA", 'S');
        this.add("UCG", 'S');
        this.add("CCU", 'P');
        this.add("CCC", 'P');
        this.add("CCA", 'P');
        this.add("CCG", 'P');
        this.add("ACU", 'T');
        this.add("ACC", 'T');
        this.add("ACA", 'T');
        this.add("ACG", 'T');
        this.add("GCU", 'A');
        this.add("GCC", 'A');
        this.add("GCA", 'A');
        this.add("GCG", 'A');
        this.add("UAU", 'Y');
        this.add("UAC", 'Y');
        this.add("UAA", '*');
        this.add("UAG", '*');
        this.add("CAU", 'H');
        this.add("CAC", 'H');
        this.add("CAA", 'Q');
        this.add("CAG", 'Q');
        this.add("AAU", 'N');
        this.add("AAC", 'N');
        this.add("AAA", 'K');
        this.add("AAG", 'K');
        this.add("GAU", 'D');
        this.add("GAC", 'D');
        this.add("GAA", 'E');
        this.add("GAG", 'E');
        this.add("UGU", 'C');
        this.add("UGC", 'C');
        this.add("UGA", '*');
        this.add("UGG", 'W');
        this.add("CGU", 'R');
        this.add("CGC", 'R');
        this.add("CGA", 'R');
        this.add("CGG", 'R');
        this.add("AGU", 'S');
        this.add("AGC", 'S');
        this.add("AGA", 'R');
        this.add("AGG", 'R');
        this.add("GGU", 'G');
        this.add("GGC", 'G');
        this.add("GGA", 'G');
        this.add("GGG", 'G');
    }

    public void check() {
        System.out.println("Checking");
        int i = 0;
        while (i < this.translations_.length) {
            if (this.translations_[i] == -1) {
                System.out.println("No Translation for codon:" + i + "(" + new String(this.generalizedCodons_.getCodonFromCodonIndex(i)) + ")");
            }
            ++i;
        }
    }

    public int[] getTerminatorIndexes() {
        return this.terminatorIndexes_;
    }

    public int getNumberOfTerminatorIndexes() {
        return this.terminatorIndexes_.length;
    }
}

