/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.alignment.SitePattern;
import pal.eval.LikelihoodValue;
import pal.math.UnivariateFunction;
import pal.substmodel.SubstitutionModel;
import pal.tree.Node;

class BranchLikelihood
implements UnivariateFunction {
    private LikelihoodValue lv;
    private double[][][] multPartial;
    private double[][][] multPartial1;
    private double[][][] multPartial2;
    private byte[] seq;
    private int numStates;
    private int numRates;
    private int numPatterns;
    private double[] frequency;
    private double[] rprob;
    private SitePattern sitePattern;
    private SubstitutionModel model;
    private Node branch;

    public BranchLikelihood(LikelihoodValue lv) {
        this.lv = lv;
        this.update();
    }

    public void update() {
        this.model = this.lv.getModel();
        this.numPatterns = this.lv.numPatterns;
        this.numRates = this.lv.numRates;
        this.numStates = this.lv.numStates;
        this.frequency = this.lv.frequency;
        this.rprob = this.lv.rprob;
        this.sitePattern = this.lv.sitePattern;
    }

    public void setBranch(Node branch) {
        if (branch.isRoot()) {
            throw new IllegalArgumentException();
        }
        if (branch.isLeaf()) {
            Node multNode = this.lv.getNextBranch(branch, branch.getParent());
            this.multPartial = this.lv.getPartial(multNode);
            this.seq = branch.getSequence();
        } else {
            Node multNode1 = this.lv.getNextBranch(branch, branch.getParent());
            this.multPartial1 = this.lv.getPartial(multNode1);
            Node multNode2 = this.lv.getNextBranch(branch, branch);
            this.multPartial2 = this.lv.getPartial(multNode2);
        }
        this.branch = branch;
    }

    public double evaluate(double arc) {
        this.model.setDistance(arc);
        this.lv.logL = 0.0;
        int l = 0;
        while (l < this.numPatterns) {
            double rsum = 0.0;
            int r = 0;
            while (r < this.numRates) {
                double sum = 0.0;
                if (this.branch.isLeaf()) {
                    int d;
                    double[] mp = this.multPartial[l][r];
                    byte sl = this.seq[l];
                    if (sl == this.numStates) {
                        d = 0;
                        while (d < this.numStates) {
                            sum += this.frequency[d] * mp[d];
                            ++d;
                        }
                    } else {
                        d = 0;
                        while (d < this.numStates) {
                            sum += this.frequency[d] * mp[d] * this.model.transProb(r, d, sl);
                            ++d;
                        }
                    }
                } else {
                    double[] mp1 = this.multPartial1[l][r];
                    double[] mp2 = this.multPartial2[l][r];
                    int i = 0;
                    while (i < this.numStates) {
                        double sum2 = 0.0;
                        int j = 0;
                        while (j < this.numStates) {
                            sum2 += mp2[j] * this.model.transProb(r, i, j);
                            ++j;
                        }
                        sum += this.frequency[i] * mp1[i] * sum2;
                        ++i;
                    }
                }
                rsum += (sum *= this.rprob[r]);
                ++r;
            }
            this.lv.siteLogL[l] = Math.log(rsum);
            this.lv.logL += this.lv.siteLogL[l] * (double)this.sitePattern.weight[l];
            ++l;
        }
        return -this.lv.logL;
    }

    public double getLowerBound() {
        return 1.0E-9;
    }

    public double getUpperBound() {
        return 100.0;
    }
}

