/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Color;
import java.awt.Graphics;
import pal.gui.NameColouriser;
import pal.gui.Painter;
import pal.gui.PositionedNode;
import pal.misc.LabelMapping;
import pal.misc.TimeOrderCharacterData;
import pal.tree.DatedTipsClockTree;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public abstract class TreePainter
implements Painter {
    public static final Color BACKGROUND = Color.white;
    public static final Color FOREGROUND = Color.black;
    public static final Color NORMAL_LABEL_COLOR = Color.green.darker();
    public static final Color HILITED_LABEL_COLOR = Color.red.darker();
    public static final Color BOOTSTRAP_SUPPORT_COLOUR = Color.black;
    public PositionedNode treeNode;
    public String title_;
    protected String attName = null;
    boolean showTitle_;
    private Tree tree;
    private TimeOrderCharacterData tocd = null;
    double width;
    double height;
    double maxLeafTime = 0.0;
    double sizeOfScale = 0.0;
    private int penWidth = 2;
    private boolean usingColor = true;
    private boolean showingNodeHeights = false;
    protected boolean showingInternalLabels = true;
    private boolean usingSymbols = false;
    private NameColouriser colouriser_ = null;
    private LabelMapping labelMapping_ = null;

    public TreePainter(Tree toDisplay, String title, boolean showTitle) {
        this.title_ = title;
        this.showTitle_ = showTitle;
        this.tree = toDisplay;
        if (toDisplay instanceof DatedTipsClockTree) {
            this.tocd = ((DatedTipsClockTree)toDisplay).getTimeOrderCharacterData();
        }
        this.standardTreePrep();
    }

    protected int getBootstrapValue(PositionedNode node) {
        Object o = this.tree.getAttribute(node.getPeer(), "bootstrap");
        if (o == null) {
            return -1;
        }
        return (Integer)o;
    }

    protected void standardTreePrep() {
        TreeUtils.rotateByLeafCount(this.tree);
        this.treeNode = new PositionedNode(this.tree.getRoot());
        this.treeNode.calculatePositions();
        this.width = NodeUtils.getLeafCount(this.treeNode);
        this.height = this.treeNode.getNodeHeight();
        this.maxLeafTime = 0.0;
        this.maxLeafTime = TreePainter.getMaxLeafTime(this.treeNode);
        this.maxLeafTime *= 1.5;
        this.sizeOfScale = this.getSizeOfScale(this.height / 5.0);
    }

    public final void setAttributeName(String name) {
        this.attName = name;
    }

    public final void setPenWidth(int p) {
        this.penWidth = p;
    }

    public final int getPenWidth() {
        return this.penWidth;
    }

    public final void setTree(Tree tree) {
        this.tree = tree;
        this.standardTreePrep();
    }

    public final void setUsingColor(boolean use) {
        this.usingColor = use;
    }

    public final boolean isUsingColor() {
        return this.usingColor;
    }

    public final void setShowingNodeHeights(boolean s) {
        this.showingNodeHeights = s;
    }

    public final boolean isShowingNodeHeights() {
        return this.showingNodeHeights;
    }

    public final boolean isShowingInternalLabels() {
        return this.showingInternalLabels;
    }

    public final TimeOrderCharacterData getTimeOrderCharacterData() {
        return this.tocd;
    }

    public final void setTimeOrderCharacterData(TimeOrderCharacterData tocd) {
        this.tocd = tocd;
        this.usingSymbols = true;
    }

    public final boolean isUsingSymbols() {
        return this.usingSymbols;
    }

    public final void setUsingSymbols(boolean use) {
        this.usingSymbols = use;
        if (this.tocd == null) {
            this.usingSymbols = false;
        }
    }

    protected final Tree getTree() {
        return this.tree;
    }

    protected final double getSizeOfScale(double target) {
        double sos = 0.1;
        boolean accept = false;
        boolean divideByTwo = true;
        while (!accept) {
            if (sos / target >= 5.0) {
                sos /= divideByTwo ? 2.0 : 5.0;
                divideByTwo = !divideByTwo;
                continue;
            }
            if (sos / target < 0.2) {
                sos *= divideByTwo ? 5.0 : 2.0;
                divideByTwo = !divideByTwo;
                continue;
            }
            accept = true;
        }
        return sos;
    }

    protected static final double getMaxLeafTime(Node node) {
        if (!node.isLeaf()) {
            double max = TreePainter.getMaxLeafTime(node.getChild(0));
            double posmax = 0.0;
            int i = 1;
            while (i < node.getChildCount()) {
                posmax = TreePainter.getMaxLeafTime(node.getChild(i));
                if (posmax > max) {
                    max = posmax;
                }
                ++i;
            }
            return max;
        }
        return node.getNodeHeight();
    }

    public static final void drawSymbol(Graphics g, int x, int y, int width, int index) {
        int halfWidth = width / 2;
        switch (index % 6) {
            case 0: {
                g.fillRect(x, y, width, width);
                break;
            }
            case 1: {
                g.drawRect(x, y, width, width);
                break;
            }
            case 2: {
                g.fillOval(x, y, width, width);
                break;
            }
            case 3: {
                g.drawOval(x, y, width, width);
                break;
            }
            case 4: {
                g.drawLine(x, y + width, x + halfWidth, y);
                g.drawLine(x + halfWidth, y, x + width, y + width);
                g.drawLine(x, y + width, x + width, y + width);
                break;
            }
            case 5: {
                g.drawLine(x, y, x + width, y + width);
                g.drawLine(x, y + width, x + width, y);
            }
        }
    }

    public final boolean isShowTitle() {
        return this.showTitle_;
    }

    public final void setColouriser(NameColouriser nc) {
        this.colouriser_ = nc;
    }

    public final void setLabelMapping(LabelMapping lp) {
        this.labelMapping_ = lp;
    }

    public final void setTitle(String title) {
        this.title_ = title;
        this.showTitle_ = true;
    }

    protected final String getNodeName(Node node) {
        if (this.labelMapping_ != null) {
            return this.labelMapping_.getLabel(node.getIdentifier());
        }
        return node.getIdentifier().getName();
    }

    public final String getTitle() {
        return this.title_;
    }

    public final void doTitle(Graphics g, int x, int y) {
        if (this.showTitle_) {
            g.drawString(this.title_, x, y);
        }
    }

    protected final void doScale(Graphics g, double xScale, int x, int y) {
        g.setColor(FOREGROUND);
        g.drawLine(x, y, x + (int)Math.round(this.sizeOfScale * xScale), y);
        g.drawString(this.sizeOfScale + (this.tree.getUnits() == 1 ? " generations" : " substitutions"), x, y - 12);
    }

    protected final Color getNodeLabelColour(Node n, Color defaultColour) {
        if (this.colouriser_ != null) {
            return this.colouriser_.getColour(n.getIdentifier(), defaultColour);
        }
        return defaultColour;
    }
}

