/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MachineAccuracy;
import pal.math.MersenneTwisterFast;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;

public class ConjugateDirectionSearch
extends MultivariateMinimum {
    public int prin = 0;
    public double step = 1.0;
    public double scbd = 1.0;
    public boolean illc = false;
    private int i;
    private int j;
    private int k;
    private int k2;
    private int nl;
    private int kl;
    private int kt;
    private double s;
    private double sl;
    private double dn;
    private double dmin;
    private double fx;
    private double f1;
    private double lds;
    private double ldt;
    private double sf;
    private double df;
    private double qf1;
    private double qd0;
    private double qd1;
    private double qa;
    private double qb;
    private double qc;
    private double small;
    private double vsmall;
    private double large;
    private double vlarge;
    private double ldfac;
    private double t2;
    private double[] d;
    private double[] y;
    private double[] z;
    private double[] q0;
    private double[] q1;
    private double[][] v;
    private double[] tflin;
    private int dim;
    private double[] x;
    private MultivariateFunction fun;
    private double h;
    private double t;
    private MersenneTwisterFast rng = new MersenneTwisterFast();
    private double min1;
    private double min2;

    public void optimize(MultivariateFunction f, double[] xvector, double tolfx, double tolx) {
        block60: {
            this.t = tolx;
            this.fun = f;
            this.x = xvector;
            this.checkBounds(this.x);
            this.h = this.step;
            this.dim = this.fun.getNumArguments();
            this.d = new double[this.dim];
            this.y = new double[this.dim];
            this.z = new double[this.dim];
            this.q0 = new double[this.dim];
            this.q1 = new double[this.dim];
            this.v = new double[this.dim][this.dim];
            this.tflin = new double[this.dim];
            this.small = MachineAccuracy.EPSILON * MachineAccuracy.EPSILON;
            this.vsmall = this.small * this.small;
            this.large = 1.0 / this.small;
            this.vlarge = 1.0 / this.vsmall;
            this.ldfac = this.illc ? 0.1 : 0.01;
            this.kt = 0;
            this.nl = 0;
            this.numFun = 1;
            this.fx = this.fun.evaluate(this.x);
            this.stopCondition(this.fx, this.x, tolfx, tolx, true);
            this.qf1 = this.fx;
            this.t = this.t2 = this.small + Math.abs(this.t);
            this.dmin = this.small;
            if (this.h < 100.0 * this.t) {
                this.h = 100.0 * this.t;
            }
            this.ldt = this.h;
            this.i = 0;
            while (this.i < this.dim) {
                this.j = 0;
                while (this.j < this.dim) {
                    this.v[this.i][this.j] = this.i == this.j ? 1.0 : 0.0;
                    ++this.j;
                }
                ++this.i;
            }
            this.d[0] = 0.0;
            this.qd0 = 0.0;
            this.i = 0;
            while (this.i < this.dim) {
                this.q1[this.i] = this.x[this.i];
                ++this.i;
            }
            if (this.prin > 1) {
                System.out.println("\n------------- enter function praxis -----------\n");
                System.out.println("... current parameter settings ...");
                System.out.println("... scaling ... " + this.scbd);
                System.out.println("...   tolx  ... " + this.t);
                System.out.println("...  tolfx  ... " + tolfx);
                System.out.println("... maxstep ... " + this.h);
                System.out.println("...   illc  ... " + this.illc);
                System.out.println("... maxFun  ... " + this.maxFun);
            }
            if (this.prin > 0) {
                System.out.println();
            }
            do {
                this.sf = this.d[0];
                this.d[0] = 0.0;
                this.s = 0.0;
                this.min1 = this.d[0];
                this.min2 = this.s;
                this.min(0, 2, this.fx, false);
                this.d[0] = this.min1;
                this.s = this.min2;
                if (this.s <= 0.0) {
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.v[this.i][0] = -this.v[this.i][0];
                        ++this.i;
                    }
                }
                if (this.sf <= 0.9 * this.d[0] || 0.9 * this.sf >= this.d[0]) {
                    this.i = 1;
                    while (this.i < this.dim) {
                        this.d[this.i] = 0.0;
                        ++this.i;
                    }
                }
                boolean gotoFret = false;
                this.k = 1;
                while (this.k < this.dim) {
                    boolean gotoNext;
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.y[this.i] = this.x[this.i];
                        ++this.i;
                    }
                    this.sf = this.fx;
                    this.illc = this.illc || this.kt > 0;
                    do {
                        this.kl = this.k;
                        this.df = 0.0;
                        if (this.illc) {
                            this.i = 0;
                            while (this.i < this.dim) {
                                this.z[this.i] = (0.1 * this.ldt + this.t2 * Math.pow(10.0, this.kt)) * (this.rng.nextDouble() - 0.5);
                                this.s = this.z[this.i];
                                this.j = 0;
                                while (this.j < this.dim) {
                                    int n = this.j;
                                    this.x[n] = this.x[n] + this.s * this.v[this.j][this.i];
                                    ++this.j;
                                }
                                ++this.i;
                            }
                            this.checkBounds(this.x);
                            this.fx = this.fun.evaluate(this.x);
                            ++this.numFun;
                        }
                        this.k2 = this.k;
                        while (this.k2 < this.dim) {
                            this.sl = this.fx;
                            this.s = 0.0;
                            this.min1 = this.d[this.k2];
                            this.min2 = this.s;
                            this.min(this.k2, 2, this.fx, false);
                            this.d[this.k2] = this.min1;
                            this.s = this.min2;
                            if (this.illc) {
                                double szk = this.s + this.z[this.k2];
                                this.s = this.d[this.k2] * szk * szk;
                            } else {
                                this.s = this.sl - this.fx;
                            }
                            if (this.df < this.s) {
                                this.df = this.s;
                                this.kl = this.k2;
                            }
                            ++this.k2;
                        }
                        if (!this.illc && this.df < Math.abs(100.0 * MachineAccuracy.EPSILON * this.fx)) {
                            this.illc = true;
                            gotoNext = true;
                            continue;
                        }
                        gotoNext = false;
                    } while (gotoNext);
                    if (this.k == 1 && this.prin > 1) {
                        this.vecprint("\n... New Direction ...", this.d);
                    }
                    this.k2 = 0;
                    while (this.k2 <= this.k - 1) {
                        this.s = 0.0;
                        this.min1 = this.d[this.k2];
                        this.min2 = this.s;
                        this.min(this.k2, 2, this.fx, false);
                        this.d[this.k2] = this.min1;
                        this.s = this.min2;
                        ++this.k2;
                    }
                    this.f1 = this.fx;
                    this.fx = this.sf;
                    this.lds = 0.0;
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.sl = this.x[this.i];
                        this.x[this.i] = this.y[this.i];
                        this.y[this.i] = this.sl - this.y[this.i];
                        this.sl = this.y[this.i];
                        this.lds += this.sl * this.sl;
                        ++this.i;
                    }
                    this.checkBounds(this.x);
                    this.lds = Math.sqrt(this.lds);
                    if (this.lds > this.small) {
                        this.i = this.kl - 1;
                        while (this.i >= this.k) {
                            this.j = 0;
                            while (this.j < this.dim) {
                                this.v[this.j][this.i + 1] = this.v[this.j][this.i];
                                ++this.j;
                            }
                            this.d[this.i + 1] = this.d[this.i];
                            --this.i;
                        }
                        this.d[this.k] = 0.0;
                        this.i = 0;
                        while (this.i < this.dim) {
                            this.v[this.i][this.k] = this.y[this.i] / this.lds;
                            ++this.i;
                        }
                        this.min1 = this.d[this.k];
                        this.min2 = this.lds;
                        this.min(this.k, 4, this.f1, true);
                        this.d[this.k] = this.min1;
                        this.lds = this.min2;
                        if (this.lds <= 0.0) {
                            this.lds = -this.lds;
                            this.i = 0;
                            while (this.i < this.dim) {
                                this.v[this.i][this.k] = -this.v[this.i][this.k];
                                ++this.i;
                            }
                        }
                    }
                    this.ldt = this.ldfac * this.ldt;
                    if (this.ldt < this.lds) {
                        this.ldt = this.lds;
                    }
                    if (this.prin > 1) {
                        this.print();
                    }
                    this.kt = this.stopCondition(this.fx, this.x, tolfx, tolx, false) ? ++this.kt : 0;
                    if (this.kt > 1) {
                        gotoFret = true;
                        break;
                    }
                    ++this.k;
                }
                if (gotoFret) break block60;
                this.quadr();
                this.dn = 0.0;
                this.i = 0;
                while (this.i < this.dim) {
                    this.d[this.i] = 1.0 / Math.sqrt(this.d[this.i]);
                    if (this.dn < this.d[this.i]) {
                        this.dn = this.d[this.i];
                    }
                    ++this.i;
                }
                if (this.prin > 2) {
                    this.matprint("\n... New Matrix of Directions ...", this.v);
                }
                this.j = 0;
                while (this.j < this.dim) {
                    this.s = this.d[this.j] / this.dn;
                    this.i = 0;
                    while (this.i < this.dim) {
                        double[] dArray = this.v[this.i];
                        int n = this.j;
                        dArray[n] = dArray[n] * this.s;
                        ++this.i;
                    }
                    ++this.j;
                }
                if (this.scbd > 1.0) {
                    this.s = this.vlarge;
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.sl = 0.0;
                        this.j = 0;
                        while (this.j < this.dim) {
                            this.sl += this.v[this.i][this.j] * this.v[this.i][this.j];
                            ++this.j;
                        }
                        this.z[this.i] = Math.sqrt(this.sl);
                        if (this.z[this.i] < MachineAccuracy.SQRT_SQRT_EPSILON) {
                            this.z[this.i] = MachineAccuracy.SQRT_SQRT_EPSILON;
                        }
                        if (this.s > this.z[this.i]) {
                            this.s = this.z[this.i];
                        }
                        ++this.i;
                    }
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.sl = this.s / this.z[this.i];
                        this.z[this.i] = 1.0 / this.sl;
                        if (this.z[this.i] > this.scbd) {
                            this.sl = 1.0 / this.scbd;
                            this.z[this.i] = this.scbd;
                        }
                        ++this.i;
                    }
                }
                this.i = 1;
                while (this.i < this.dim) {
                    this.j = 0;
                    while (this.j <= this.i - 1) {
                        this.s = this.v[this.i][this.j];
                        this.v[this.i][this.j] = this.v[this.j][this.i];
                        this.v[this.j][this.i] = this.s;
                        ++this.j;
                    }
                    ++this.i;
                }
                this.minfit(this.dim, MachineAccuracy.EPSILON, this.vsmall, this.v, this.d);
                if (this.scbd > 1.0) {
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.s = this.z[this.i];
                        this.j = 0;
                        while (this.j < this.dim) {
                            double[] dArray = this.v[this.i];
                            int n = this.j++;
                            dArray[n] = dArray[n] * this.s;
                        }
                        ++this.i;
                    }
                    this.i = 0;
                    while (this.i < this.dim) {
                        this.s = 0.0;
                        this.j = 0;
                        while (this.j < this.dim) {
                            this.s += this.v[this.j][this.i] * this.v[this.j][this.i];
                            ++this.j;
                        }
                        this.s = Math.sqrt(this.s);
                        int n = this.i;
                        this.d[n] = this.d[n] * this.s;
                        this.s = 1.0 / this.s;
                        this.j = 0;
                        while (this.j < this.dim) {
                            double[] dArray = this.v[this.j];
                            int n2 = this.i;
                            dArray[n2] = dArray[n2] * this.s;
                            ++this.j;
                        }
                        ++this.i;
                    }
                }
                this.i = 0;
                while (this.i < this.dim) {
                    this.d[this.i] = this.dn * this.d[this.i] > this.large ? this.vsmall : (this.dn * this.d[this.i] < this.small ? this.vlarge : Math.pow(this.dn * this.d[this.i], -2.0));
                    ++this.i;
                }
                this.sort();
                this.dmin = this.d[this.dim - 1];
                if (this.dmin < this.small) {
                    this.dmin = this.small;
                }
                boolean bl = this.illc = MachineAccuracy.SQRT_EPSILON * this.d[0] > this.dmin;
                if (this.prin > 2 && this.scbd > 1.0) {
                    this.vecprint("\n... Scale Factors ...", this.z);
                }
                if (this.prin > 2) {
                    this.vecprint("\n... Eigenvalues of A ...", this.d);
                }
                if (this.prin <= 2) continue;
                this.matprint("\n... Eigenvectors of A ...", this.v);
            } while (this.maxFun <= 0 || this.nl <= this.maxFun);
            if (this.prin > 0) {
                System.out.println("\n... maximum number of function calls reached ...");
            }
        }
        if (this.prin > 0) {
            this.vecprint("\n... Final solution is ...", this.x);
            System.out.println("\n... Function value reduced to " + this.fx + " ...");
            System.out.println("... after " + this.numFun + " function calls.");
        }
    }

    private void sort() {
        int i = 0;
        while (i < this.dim - 1) {
            int k = i;
            double s = this.d[i];
            int j = i + 1;
            while (j < this.dim) {
                if (this.d[j] > s) {
                    k = j;
                    s = this.d[j];
                }
                ++j;
            }
            if (k > i) {
                this.d[k] = this.d[i];
                this.d[i] = s;
                j = 0;
                while (j < this.dim) {
                    s = this.v[j][i];
                    this.v[j][i] = this.v[j][k];
                    this.v[j][k] = s;
                    ++j;
                }
            }
            ++i;
        }
    }

    private void vecprint(String s, double[] x) {
        System.out.println(s);
        int i = 0;
        while (i < x.length) {
            System.out.print(x[i] + "  ");
            ++i;
        }
        System.out.println();
    }

    private void print() {
        System.out.println();
        System.out.println("... function value reduced to ... " + this.fx);
        System.out.println("... after " + this.numFun + " function calls ...");
        System.out.println("... including " + this.nl + " linear searches ...");
        this.vecprint("... current values of x ...", this.x);
    }

    private void matprint(String s, double[][] v) {
        System.out.println(s);
        int k = 0;
        while (k < v.length) {
            int i = 0;
            while (i < v.length) {
                System.out.print(v[k][i] + " ");
                ++i;
            }
            System.out.println();
            ++k;
        }
    }

    private double flin(double l, int j) {
        if (j != -1) {
            int i = 0;
            while (i < this.dim) {
                this.tflin[i] = this.x[i] + l * this.v[i][j];
                ++i;
            }
        } else {
            this.qa = l * (l - this.qd1) / (this.qd0 * (this.qd0 + this.qd1));
            this.qb = (l + this.qd0) * (this.qd1 - l) / (this.qd0 * this.qd1);
            this.qc = l * (l + this.qd0) / (this.qd1 * (this.qd0 + this.qd1));
            int i = 0;
            while (i < this.dim) {
                this.tflin[i] = this.qa * this.q0[i] + this.qb * this.x[i] + this.qc * this.q1[i];
                ++i;
            }
        }
        this.checkBounds(this.tflin);
        ++this.numFun;
        return this.fun.evaluate(this.tflin);
    }

    private void checkBounds(double[] p) {
        int i = 0;
        while (i < this.dim) {
            if (p[i] < this.fun.getLowerBound(i)) {
                p[i] = this.fun.getLowerBound(i);
            }
            if (p[i] > this.fun.getUpperBound(i)) {
                p[i] = this.fun.getUpperBound(i);
            }
            ++i;
        }
    }

    private void min(int j, int nits, double f1, boolean fk) {
        double f2;
        double x2;
        boolean gotoNext;
        double f0;
        double sf1 = f1;
        double sx1 = this.min2;
        int k = 0;
        double xm = 0.0;
        double fm = f0 = this.fx;
        boolean dz = this.min1 < MachineAccuracy.EPSILON;
        double s = 0.0;
        int i = 0;
        while (i < this.dim) {
            s += this.x[i] * this.x[i];
            ++i;
        }
        s = Math.sqrt(s);
        double t2 = dz ? MachineAccuracy.SQRT_SQRT_EPSILON * Math.sqrt(Math.abs(this.fx) / this.dmin + s * this.ldt) + MachineAccuracy.SQRT_EPSILON * this.ldt : MachineAccuracy.SQRT_SQRT_EPSILON * Math.sqrt(Math.abs(this.fx) / this.min1 + s * this.ldt) + MachineAccuracy.SQRT_EPSILON * this.ldt;
        s = s * MachineAccuracy.SQRT_SQRT_EPSILON + this.t;
        if (dz && t2 > s) {
            t2 = s;
        }
        if (t2 < this.small) {
            t2 = this.small;
        }
        if (t2 > 0.01 * this.h) {
            t2 = 0.01 * this.h;
        }
        if (fk && f1 <= fm) {
            xm = this.min2;
            fm = f1;
        }
        if (!fk || Math.abs(this.min2) < t2) {
            this.min2 = this.min2 > 0.0 ? t2 : -t2;
            f1 = this.flin(this.min2, j);
        }
        if (f1 <= fm) {
            xm = this.min2;
            fm = f1;
        }
        block1: do {
            if (dz) {
                x2 = f0 < f1 ? -this.min2 : 2.0 * this.min2;
                f2 = this.flin(x2, j);
                if (f2 <= fm) {
                    xm = x2;
                    fm = f2;
                }
                this.min1 = (x2 * (f1 - f0) - this.min2 * (f2 - f0)) / (this.min2 * x2 * (this.min2 - x2));
            }
            double d1 = (f1 - f0) / this.min2 - this.min2 * this.min1;
            dz = true;
            x2 = this.min1 <= this.small ? (d1 < 0.0 ? this.h : -this.h) : -0.5 * d1 / this.min1;
            if (Math.abs(x2) > this.h) {
                x2 = x2 > 0.0 ? this.h : -this.h;
            }
            f2 = this.flin(x2, j);
            gotoNext = false;
            while (k < nits && f2 > f0) {
                ++k;
                if (f0 < f1 && this.min2 * x2 > 0.0) {
                    gotoNext = true;
                    continue block1;
                }
                f2 = this.flin(x2 *= 0.5, j);
            }
        } while (gotoNext);
        ++this.nl;
        if (f2 > fm) {
            x2 = xm;
        } else {
            fm = f2;
        }
        if (Math.abs(x2 * (x2 - this.min2)) > this.small) {
            this.min1 = (x2 * (f1 - f0) - this.min2 * (fm - f0)) / (this.min2 * x2 * (this.min2 - x2));
        } else if (k > 0) {
            this.min1 = 0.0;
        }
        if (this.min1 <= this.small) {
            this.min1 = this.small;
        }
        this.min2 = x2;
        this.fx = fm;
        if (sf1 < this.fx) {
            this.fx = sf1;
            this.min2 = sx1;
        }
        if (j != -1) {
            this.i = 0;
            while (this.i < this.dim) {
                int n = this.i;
                this.x[n] = this.x[n] + this.min2 * this.v[this.i][j];
                ++this.i;
            }
            this.checkBounds(this.x);
        }
    }

    private void quadr() {
        double l;
        double s = this.fx;
        this.fx = this.qf1;
        this.qf1 = s;
        this.qd1 = 0.0;
        int i = 0;
        while (i < this.dim) {
            s = this.x[i];
            this.x[i] = l = this.q1[i];
            this.q1[i] = s;
            this.qd1 += (s - l) * (s - l);
            ++i;
        }
        s = 0.0;
        l = this.qd1 = Math.sqrt(this.qd1);
        if (this.qd0 > 0.0 && this.qd1 > 0.0 && this.nl >= 3 * this.dim * this.dim) {
            this.min1 = s;
            this.min2 = l;
            this.min(-1, 2, this.qf1, true);
            s = this.min1;
            l = this.min2;
            this.qa = l * (l - this.qd1) / (this.qd0 * (this.qd0 + this.qd1));
            this.qb = (l + this.qd0) * (this.qd1 - l) / (this.qd0 * this.qd1);
            this.qc = l * (l + this.qd0) / (this.qd1 * (this.qd0 + this.qd1));
        } else {
            this.fx = this.qf1;
            this.qb = 0.0;
            this.qa = 0.0;
            this.qc = 1.0;
        }
        this.qd0 = this.qd1;
        i = 0;
        while (i < this.dim) {
            s = this.q0[i];
            this.q0[i] = this.x[i];
            this.x[i] = this.qa * s + this.qb * this.x[i] + this.qc * this.q1[i];
            ++i;
        }
        this.checkBounds(this.x);
    }

    private void minfit(int n, double eps, double tol, double[][] ab, double[] q) {
        double y;
        int k;
        double h;
        double f;
        int j;
        double s;
        int l = 0;
        double[] e = new double[this.dim];
        double g = 0.0;
        double x = 0.0;
        int i = 0;
        while (i < n) {
            e[i] = g;
            s = 0.0;
            l = i + 1;
            j = i;
            while (j < n) {
                s += ab[j][i] * ab[j][i];
                ++j;
            }
            if (s < tol) {
                g = 0.0;
            } else {
                f = ab[i][i];
                g = f < 0.0 ? Math.sqrt(s) : -Math.sqrt(s);
                h = f * g - s;
                ab[i][i] = f - g;
                j = l;
                while (j < n) {
                    f = 0.0;
                    k = i;
                    while (k < n) {
                        f += ab[k][i] * ab[k][j];
                        ++k;
                    }
                    f /= h;
                    k = i;
                    while (k < n) {
                        double[] dArray = ab[k];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + f * ab[k][i];
                        ++k;
                    }
                    ++j;
                }
            }
            q[i] = g;
            s = 0.0;
            if (i < n) {
                j = l;
                while (j < n) {
                    s += ab[i][j] * ab[i][j];
                    ++j;
                }
            }
            if (s < tol) {
                g = 0.0;
            } else {
                f = ab[i][i + 1];
                g = f < 0.0 ? Math.sqrt(s) : -Math.sqrt(s);
                h = f * g - s;
                ab[i][i + 1] = f - g;
                j = l;
                while (j < n) {
                    e[j] = ab[i][j] / h;
                    ++j;
                }
                j = l;
                while (j < n) {
                    s = 0.0;
                    k = l;
                    while (k < n) {
                        s += ab[j][k] * ab[i][k];
                        ++k;
                    }
                    k = l;
                    while (k < n) {
                        double[] dArray = ab[j];
                        int n3 = k;
                        dArray[n3] = dArray[n3] + s * e[k];
                        ++k;
                    }
                    ++j;
                }
            }
            y = Math.abs(q[i]) + Math.abs(e[i]);
            if (y > x) {
                x = y;
            }
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            if (g != 0.0) {
                h = ab[i][i + 1] * g;
                j = l;
                while (j < n) {
                    ab[j][i] = ab[i][j] / h;
                    ++j;
                }
                j = l;
                while (j < n) {
                    s = 0.0;
                    k = l;
                    while (k < n) {
                        s += ab[i][k] * ab[k][j];
                        ++k;
                    }
                    k = l;
                    while (k < n) {
                        double[] dArray = ab[k];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + s * ab[k][i];
                        ++k;
                    }
                    ++j;
                }
            }
            j = l;
            while (j < n) {
                ab[j][i] = 0.0;
                ab[i][j] = 0.0;
                ++j;
            }
            ab[i][i] = 1.0;
            g = e[i];
            l = i--;
        }
        eps *= x;
        boolean converged = false;
        k = n - 1;
        while (k >= 0) {
            double z;
            int kt = 0;
            do {
                double c;
                ++kt;
                boolean skipNext = false;
                int l2 = k;
                while (l2 >= 0) {
                    if (Math.abs(e[l = l2--]) <= eps) {
                        skipNext = true;
                        break;
                    }
                    if (Math.abs(q[l - 1]) <= eps) break;
                }
                if (!skipNext) {
                    c = 0.0;
                    s = 1.0;
                    i = l;
                    while (i <= k) {
                        f = s * e[i];
                        int n5 = i;
                        e[n5] = e[n5] * c;
                        if (Math.abs(f) <= eps) break;
                        g = q[i];
                        if (Math.abs(f) < Math.abs(g)) {
                            double fg = f / g;
                            h = Math.abs(g) * Math.sqrt(1.0 + fg * fg);
                        } else {
                            double gf = g / f;
                            h = f != 0.0 ? Math.abs(f) * Math.sqrt(1.0 + gf * gf) : 0.0;
                        }
                        q[i] = h;
                        if (h == 0.0) {
                            h = 1.0;
                            g = 1.0;
                        }
                        c = g / h;
                        s = -f / h;
                        ++i;
                    }
                }
                z = q[k];
                if (l == k) {
                    converged = true;
                    break;
                }
                x = q[l];
                y = q[k - l];
                g = e[k - 1];
                h = e[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = Math.sqrt(f * f + 1.0);
                f = f <= 0.0 ? ((x - z) * (x + z) + h * (y / (f - g) - h)) / x : ((x - z) * (x + z) + h * (y / (f + g) - h)) / x;
                c = 1.0;
                s = 1.0;
                i = l + 1;
                while (i <= k) {
                    double hf;
                    double fh;
                    g = e[i];
                    y = q[i];
                    h = s * g;
                    g *= c;
                    if (Math.abs(f) < Math.abs(h)) {
                        fh = f / h;
                        z = Math.abs(h) * Math.sqrt(1.0 + fh * fh);
                    } else {
                        hf = h / f;
                        z = f != 0.0 ? Math.abs(f) * Math.sqrt(1.0 + hf * hf) : 0.0;
                    }
                    e[i - 1] = z;
                    if (z == 0.0) {
                        z = 1.0;
                        f = 1.0;
                    }
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = -x * s + g * c;
                    h = y * s;
                    y *= c;
                    j = 0;
                    while (j < n) {
                        x = ab[j][i - 1];
                        z = ab[j][i];
                        ab[j][i - 1] = x * c + z * s;
                        ab[j][i] = -x * s + z * c;
                        ++j;
                    }
                    if (Math.abs(f) < Math.abs(h)) {
                        fh = f / h;
                        z = Math.abs(h) * Math.sqrt(1.0 + fh * fh);
                    } else {
                        hf = h / f;
                        z = f != 0.0 ? Math.abs(f) * Math.sqrt(1.0 + hf * hf) : 0.0;
                    }
                    q[i - 1] = z;
                    if (z == 0.0) {
                        f = 1.0;
                        z = 1.0;
                    }
                    c = f / z;
                    s = h / z;
                    f = c * g + s * y;
                    x = -s * g + c * y;
                    ++i;
                }
                e[l] = 0.0;
                e[k] = f;
                q[k] = x;
            } while (kt <= 30);
            if (!converged) {
                e[k] = 0.0;
                System.out.println("\n+++ qr failed\n");
                System.exit(1);
            }
            if (z < 0.0) {
                q[k] = -z;
                j = 0;
                while (j < n) {
                    ab[j][k] = -ab[j][k];
                    ++j;
                }
            }
            --k;
        }
    }
}

