/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MersenneTwisterFast;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;

public class DifferentialEvolution
extends MultivariateMinimum {
    public double F = 0.7;
    public double CR = 0.9;
    public int prin = 0;
    private MultivariateFunction f;
    private int currGen;
    private double fx;
    private double[] x;
    private int dimension;
    private int populationSize;
    private double trialCost;
    private double[] costs;
    private double[] trialVector;
    private double[][] currentPopulation;
    private double[][] nextPopulation;
    private MersenneTwisterFast rng = new MersenneTwisterFast();
    private int numr;
    private int[] r;

    public DifferentialEvolution(int dim) {
        this(dim, 5 * dim);
    }

    public DifferentialEvolution(int dim, int popSize) {
        this.dimension = dim;
        this.populationSize = popSize;
        this.numFun = 0;
        this.currentPopulation = new double[this.populationSize][this.dimension];
        this.nextPopulation = new double[this.populationSize][this.dimension];
        this.costs = new double[this.populationSize];
        this.trialVector = new double[this.dimension];
        this.numr = 3;
        this.r = new int[this.numr];
    }

    public void optimize(MultivariateFunction func, double[] xvec, double tolfx, double tolx) {
        this.f = func;
        this.x = xvec;
        this.firstGeneration();
        this.stopCondition(this.fx, this.x, tolfx, tolx, true);
        while (true) {
            boolean xHasChanged = this.nextGeneration();
            if (this.maxFun <= 0 || this.numFun <= this.maxFun) {
                if (this.prin > 1 && this.currGen % 20 == 0) {
                    this.printStatistics();
                }
                if (!xHasChanged) continue;
            }
            if (this.stopCondition(this.fx, this.x, tolfx, tolx, false) || this.maxFun > 0 && this.numFun > this.maxFun) break;
        }
        if (this.prin > 0) {
            this.printStatistics();
        }
    }

    private void printStatistics() {
        double meanCost = 0.0;
        int i = 0;
        while (i < this.populationSize) {
            meanCost += this.costs[i];
            ++i;
        }
        meanCost /= (double)this.populationSize;
        double varCost = 0.0;
        int i2 = 0;
        while (i2 < this.populationSize) {
            double tmp = this.costs[i2] - meanCost;
            varCost += tmp * tmp;
            ++i2;
        }
        varCost /= (double)(this.populationSize - 1);
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("Smallest value: " + this.fx);
        System.out.println();
        int k = 0;
        while (k < this.dimension) {
            System.out.println("x[" + k + "] = " + this.x[k]);
            ++k;
        }
        System.out.println();
        System.out.println("Current Generation: " + this.currGen);
        System.out.println("Function evaluations: " + this.numFun);
        System.out.println("Populations size (populationSize): " + this.populationSize);
        System.out.println("Average value: " + meanCost);
        System.out.println("Variance: " + varCost);
        System.out.println("Weight factor (F): " + this.F);
        System.out.println("Crossing-over (CR): " + this.CR);
        System.out.println();
    }

    private void firstGeneration() {
        this.currGen = 1;
        int i = 0;
        while (i < this.populationSize) {
            int j = 0;
            while (j < this.dimension) {
                double min = this.f.getLowerBound(j);
                double max = this.f.getUpperBound(j);
                double diff = max - min;
                this.currentPopulation[i][j] = min + diff * this.rng.nextDouble();
                ++j;
            }
            this.costs[i] = this.f.evaluate(this.currentPopulation[i]);
            ++i;
        }
        this.numFun += this.populationSize;
        this.findSmallestCost();
    }

    private double checkBounds(double param, int numParam) {
        if (param < this.f.getLowerBound(numParam)) {
            return this.f.getLowerBound(numParam);
        }
        if (param > this.f.getUpperBound(numParam)) {
            return this.f.getUpperBound(numParam);
        }
        return param;
    }

    private boolean nextGeneration() {
        boolean updateFlag = false;
        int best = 0;
        ++this.currGen;
        int r0 = 0;
        while (r0 < this.populationSize) {
            this.r[0] = r0;
            int k = 1;
            while (k < this.numr) {
                this.r[k] = this.randomInteger(this.populationSize - k);
                int l = 0;
                while (l < k) {
                    if (this.r[k] >= this.r[l]) {
                        int n = k;
                        this.r[n] = this.r[n] + 1;
                    }
                    ++l;
                }
                ++k;
            }
            this.copy(this.trialVector, this.currentPopulation[r0]);
            int n = this.randomInteger(this.dimension);
            int i = 0;
            while (i < this.dimension) {
                if (this.rng.nextDouble() < this.CR || i == this.dimension - 1) {
                    this.trialVector[n] = this.trialVector[n] + this.F * (this.x[n] - this.trialVector[n]) + this.F * (this.currentPopulation[this.r[1]][n] - this.currentPopulation[this.r[2]][n]);
                }
                n = (n + 1) % this.dimension;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.dimension) {
                this.trialVector[i2] = this.checkBounds(this.trialVector[i2], i2);
                ++i2;
            }
            this.trialCost = this.f.evaluate(this.trialVector);
            if (this.trialCost < this.costs[r0]) {
                this.costs[r0] = this.trialCost;
                this.copy(this.nextPopulation[r0], this.trialVector);
                if (this.trialCost < this.fx) {
                    this.fx = this.trialCost;
                    best = r0;
                    updateFlag = true;
                }
            } else {
                this.copy(this.nextPopulation[r0], this.currentPopulation[r0]);
            }
            ++r0;
        }
        this.numFun += this.populationSize;
        if (updateFlag) {
            this.copy(this.x, this.nextPopulation[best]);
        }
        double[][] swap = this.currentPopulation;
        this.currentPopulation = this.nextPopulation;
        this.nextPopulation = swap;
        return updateFlag;
    }

    private void findSmallestCost() {
        int best = 0;
        this.fx = this.costs[0];
        int i = 1;
        while (i < this.populationSize) {
            if (this.costs[i] < this.fx) {
                this.fx = this.costs[i];
                best = i;
            }
            ++i;
        }
        this.copy(this.x, this.currentPopulation[best]);
    }

    private int randomInteger(int n) {
        return this.rng.nextInt(n);
    }
}

