/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.statistics.DiscreteStatistics;
import pal.util.HeapSort;

public class BootstrapStatistics {
    public static double computeBIAS(double thetaHat, double[] thetaHatStar) {
        double thetaHatStarMean = DiscreteStatistics.mean(thetaHatStar);
        return thetaHatStarMean - thetaHat;
    }

    public static double biasCorrectedEstimate(double thetaHat, double[] thetaHatStar) {
        return thetaHat - BootstrapStatistics.computeBIAS(thetaHat, thetaHatStar);
    }

    public static double computeVAR(double[] thetaHatStar) {
        return DiscreteStatistics.variance(thetaHatStar);
    }

    public static double computeSD(double[] thetaHatStar) {
        return DiscreteStatistics.stdev(thetaHatStar);
    }

    public static double[] efronCI(double level, double[] thetaHatStar) {
        int[] indices = new int[thetaHatStar.length];
        return BootstrapStatistics.efronCI(level, thetaHatStar, indices);
    }

    public static double[] efronCI(double level, double[] thetaHatStar, int[] array) {
        HeapSort.sort(thetaHatStar, array);
        double alpha = (1.0 - level) / 2.0;
        double[] result = new double[]{DiscreteStatistics.quantile(alpha, thetaHatStar, array), DiscreteStatistics.quantile(1.0 - alpha, thetaHatStar, array)};
        return result;
    }

    public static double[] hallCI(double level, double thetaHat, double[] thetaHatStar) {
        int[] indices = new int[thetaHatStar.length];
        return BootstrapStatistics.hallCI(level, thetaHat, thetaHatStar, indices);
    }

    public static double[] hallCI(double level, double thetaHat, double[] thetaHatStar, int[] array) {
        HeapSort.sort(thetaHatStar, array);
        double alpha = (1.0 - level) / 2.0;
        double[] result = new double[2];
        double t1 = DiscreteStatistics.quantile(alpha, thetaHatStar, array) - thetaHat;
        double t2 = DiscreteStatistics.quantile(1.0 - alpha, thetaHatStar, array) - thetaHat;
        result[0] = thetaHat - t2;
        result[1] = thetaHat - t1;
        return result;
    }
}

