/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.math.MersenneTwisterFast;

public class ContigencyTable {
    MersenneTwisterFast intRand = new MersenneTwisterFast();
    int[][] contig;
    int csum;
    int rows;
    int cols;
    int[] crow;
    int[] ccol;
    int[] rowDist;
    int[] colDist;
    float[][] expectation;
    private double[] f;
    double mcF;
    int maxSize;

    public ContigencyTable(int maxSize) {
        this.maxSize = 2 * maxSize;
        this.f = new double[this.maxSize + 1];
        this.f[0] = 0.0;
        int i = 1;
        while (i <= this.maxSize) {
            this.f[i] = this.f[i - 1] + Math.log(i);
            ++i;
        }
    }

    public void setMatrix(int[][] tcontig) {
        int j;
        int count = 0;
        this.rows = tcontig.length;
        this.cols = tcontig[0].length;
        this.contig = tcontig;
        this.csum = 0;
        this.crow = new int[this.rows];
        this.ccol = new int[this.cols];
        int i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.cols) {
                this.csum += this.contig[i][j];
                int n = i;
                this.crow[n] = this.crow[n] + this.contig[i][j];
                int n2 = j;
                this.ccol[n2] = this.ccol[n2] + this.contig[i][j];
                ++j;
            }
            ++i;
        }
        if (this.csum > this.maxSize) {
            this.contig = null;
            return;
        }
        this.rowDist = new int[this.csum];
        this.colDist = new int[this.csum];
        i = 0;
        while (i < this.rows) {
            j = 0;
            while (j < this.cols) {
                int k = 0;
                while (k < this.contig[i][j]) {
                    this.rowDist[count] = i;
                    this.colDist[count] = j;
                    ++count;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (this.maxSize > 0) {
            this.mcF = 0.0;
            i = 0;
            while (i < this.rows) {
                this.mcF += this.f[this.crow[i]];
                ++i;
            }
            j = 0;
            while (j < this.cols) {
                this.mcF += this.f[this.ccol[j]];
                ++j;
            }
            this.mcF -= this.f[2 * this.csum];
        }
    }

    final float calcchiSquare() {
        float chi = 0.0f;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (this.contig[i][j] > 0) {
                    float E = this.expectation[i][j];
                    chi += ((float)this.contig[i][j] - E) * ((float)this.contig[i][j] - E) / E;
                }
                ++j;
            }
            ++i;
        }
        return chi;
    }

    final double calcLnFisherExactP() {
        double lnFisherExactP = this.mcF;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                lnFisherExactP -= this.f[this.contig[i][j]];
                ++j;
            }
            ++i;
        }
        return lnFisherExactP;
    }

    final void randomcontig() {
        boolean sum = false;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                this.contig[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.csum) {
            int r = this.intRand.nextInt(this.csum);
            int temp = this.rowDist[i];
            this.rowDist[i] = this.rowDist[r];
            this.rowDist[r] = temp;
            ++i;
        }
        i = 0;
        while (i < this.csum) {
            int[] nArray = this.contig[this.rowDist[i]];
            int n = this.colDist[i];
            nArray[n] = nArray[n] + 1;
            ++i;
        }
    }

    public double calcRapidContigencyChiSquare(int maxPermutations) {
        int reps = maxPermutations;
        double chiprob = 0.0;
        double Origchi = 0.0;
        if (this.contig == null) {
            return Double.NaN;
        }
        int r = 0;
        while (r <= reps) {
            if (r > 0) {
                this.randomcontig();
            }
            double X = this.calcchiSquare();
            if (r == 0) {
                Origchi = X;
            } else if (X >= Origchi) {
                chiprob += 1.0;
            }
            if (chiprob > 9.0) {
                reps = r - 1;
            }
            ++r;
        }
        return chiprob / (double)r;
    }

    public double calcContigencyChiSquare(int permutations) {
        double chiprob = 0.0;
        double Origchi = 0.0;
        if (this.contig == null) {
            return Double.NaN;
        }
        int r = 0;
        while (r <= permutations) {
            if (r > 0) {
                this.randomcontig();
            }
            double X = this.calcchiSquare();
            if (r == 0) {
                Origchi = X;
            } else if (X >= Origchi) {
                chiprob += 1.0;
            }
            ++r;
        }
        return chiprob / (double)r;
    }

    public double calcRapidMonteCarloExactTest(int maxPermutations) {
        int reps = maxPermutations;
        double mCFEprob = 0.0;
        double origMCFE = 0.0;
        if (this.contig == null) {
            return Double.NaN;
        }
        int r = 0;
        while (r <= reps) {
            if (r > 0) {
                this.randomcontig();
            }
            double fE = this.calcLnFisherExactP();
            if (r == 0) {
                origMCFE = fE;
            } else if (fE <= origMCFE) {
                mCFEprob += 1.0;
            }
            if (mCFEprob > 9.0) {
                reps = r - 1;
            }
            ++r;
        }
        return mCFEprob / (double)r;
    }

    public double calcMonteCarloExactTest(int permutations) {
        double mCFEprob = 0.0;
        double origMCFE = 0.0;
        if (this.contig == null) {
            return Double.NaN;
        }
        int r = 0;
        while (r <= permutations) {
            if (r > 0) {
                this.randomcontig();
            }
            double fE = this.calcLnFisherExactP();
            if (r == 0) {
                origMCFE = fE;
            } else if (fE <= origMCFE) {
                mCFEprob += 1.0;
            }
            ++r;
        }
        return mCFEprob / (double)r;
    }

    void writeMatrix() {
        int i = 0;
        while (i < this.rows) {
            System.out.print("r" + i + "   ");
            int j = 0;
            while (j < this.cols) {
                System.out.print(this.contig[i][j] + "  ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

