/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.math.GammaFunction;
import pal.statistics.NormalDistribution;

public class GammaDistribution {
    public static double pdf(double x, double shape, double scale) {
        return Math.pow(scale, -shape) * Math.pow(x, shape - 1.0) / Math.exp(x / scale + GammaFunction.lnGamma(shape));
    }

    public static double cdf(double x, double shape, double scale) {
        return GammaFunction.incompleteGammaP(shape, x / scale);
    }

    public static double quantile(double y, double shape, double scale) {
        return 0.5 * scale * GammaDistribution.pointChi2(y, 2.0 * shape);
    }

    public static double mean(double shape, double scale) {
        return scale * shape;
    }

    public static double variance(double shape, double scale) {
        return scale * scale * shape;
    }

    private static double pointChi2(double prob, double v) {
        double s6;
        double s5;
        double s4;
        double s3;
        double s2;
        double s1;
        double ch;
        double e = 5.0E-7;
        double aa = 0.6931471805;
        double p = prob;
        double a = 0.0;
        double q = 0.0;
        double p1 = 0.0;
        double p2 = 0.0;
        double t = 0.0;
        double x = 0.0;
        double b = 0.0;
        if (p < 2.0E-6 || p > 0.999998 || v <= 0.0) {
            throw new IllegalArgumentException("Arguments out of range");
        }
        double g = GammaFunction.lnGamma(v / 2.0);
        double xx = v / 2.0;
        double c = xx - 1.0;
        if (v < -1.24 * Math.log(p)) {
            ch = Math.pow(p * xx * Math.exp(g + xx * aa), 1.0 / xx);
            if (ch - e < 0.0) {
                return ch;
            }
        } else if (v > 0.32) {
            x = NormalDistribution.quantile(p, 0.0, 1.0);
            ch = v * Math.pow(x * Math.sqrt(p1 = 0.222222 / v) + 1.0 - p1, 3.0);
            if (ch > 2.2 * v + 6.0) {
                ch = -2.0 * (Math.log(1.0 - p) - c * Math.log(0.5 * ch) + g);
            }
        } else {
            ch = 0.4;
            a = Math.log(1.0 - p);
            do {
                q = ch;
                p1 = 1.0 + ch * (4.67 + ch);
                p2 = ch * (6.73 + ch * (6.66 + ch));
                t = -0.5 + (4.67 + 2.0 * ch) / p1 - (6.73 + ch * (13.32 + 3.0 * ch)) / p2;
            } while (Math.abs(q / (ch -= (1.0 - Math.exp(a + g + 0.5 * ch + c * aa) * p2 / p1) / t) - 1.0) - 0.01 > 0.0);
        }
        do {
            double d;
            q = ch;
            p1 = 0.5 * ch;
            t = GammaFunction.incompleteGammaP(xx, p1, g);
            if (!(d < 0.0)) continue;
            throw new IllegalArgumentException("Arguments out of range: t < 0");
        } while (Math.abs(q / (ch += (t = (p2 = p - t) * Math.exp(xx * aa + g + p1 - c * Math.log(ch))) * (1.0 + 0.5 * t * (s1 = (210.0 + (a = 0.5 * t - (b = t / ch) * c) * (140.0 + a * (105.0 + a * (84.0 + a * (70.0 + 60.0 * a))))) / 420.0) - b * c * (s1 - b * ((s2 = (420.0 + a * (735.0 + a * (966.0 + a * (1141.0 + 1278.0 * a)))) / 2520.0) - b * ((s3 = (210.0 + a * (462.0 + a * (707.0 + 932.0 * a))) / 2520.0) - b * ((s4 = (252.0 + a * (672.0 + 1182.0 * a) + c * (294.0 + a * (889.0 + 1740.0 * a))) / 5040.0) - b * ((s5 = (84.0 + 264.0 * a + c * (175.0 + 606.0 * a)) / 2520.0) - b * (s6 = (120.0 + c * (346.0 + 127.0 * c)) / 5040.0)))))))) - 1.0) > e);
        return ch;
    }
}

