/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import pal.datatype.AminoAcids;
import pal.substmodel.AbstractRateMatrix;
import pal.substmodel.BLOSUM62;
import pal.substmodel.CPREV;
import pal.substmodel.Dayhoff;
import pal.substmodel.JTT;
import pal.substmodel.MTREV24;
import pal.substmodel.RateMatrix;
import pal.substmodel.VT;
import pal.substmodel.WAG;

public abstract class AminoAcidModel
extends AbstractRateMatrix
implements RateMatrix {
    public static AminoAcidModel getInstance(int modelID, double[] freq) {
        if (modelID == 0) {
            return new Dayhoff(freq);
        }
        if (modelID == 1) {
            return new JTT(freq);
        }
        if (modelID == 2) {
            return new MTREV24(freq);
        }
        if (modelID == 3) {
            return new BLOSUM62(freq);
        }
        if (modelID == 4) {
            return new VT(freq);
        }
        if (modelID == 5) {
            return new WAG(freq);
        }
        if (modelID == 6) {
            return new CPREV(freq);
        }
        return new Dayhoff(freq);
    }

    public static int getSuitableModelID(double[] freq) {
        int NUMMODELS = 7;
        double[] ofreq = new double[20];
        double[] dist = new double[NUMMODELS];
        Dayhoff.getOriginalFrequencies(ofreq);
        dist[0] = AminoAcidModel.getDist(freq, ofreq);
        JTT.getOriginalFrequencies(ofreq);
        dist[1] = AminoAcidModel.getDist(freq, ofreq);
        MTREV24.getOriginalFrequencies(ofreq);
        dist[2] = AminoAcidModel.getDist(freq, ofreq);
        BLOSUM62.getOriginalFrequencies(ofreq);
        dist[3] = AminoAcidModel.getDist(freq, ofreq);
        VT.getOriginalFrequencies(ofreq);
        dist[4] = AminoAcidModel.getDist(freq, ofreq);
        WAG.getOriginalFrequencies(ofreq);
        dist[5] = AminoAcidModel.getDist(freq, ofreq);
        CPREV.getOriginalFrequencies(ofreq);
        dist[6] = AminoAcidModel.getDist(freq, ofreq);
        int bestModel = 0;
        double minDist = dist[0];
        int i = 1;
        while (i < NUMMODELS) {
            if (dist[i] < minDist) {
                minDist = dist[i];
                bestModel = i;
            }
            ++i;
        }
        return bestModel;
    }

    public abstract void report(PrintWriter var1);

    public int getNumParameters() {
        return 0;
    }

    public void setParameter(double param, int n) {
    }

    public double getParameter(int n) {
        return 0.0;
    }

    public void setParameterSE(double paramSE, int n) {
    }

    public double getLowerLimit(int n) {
        return 0.0;
    }

    public double getUpperLimit(int n) {
        return 0.0;
    }

    public double getDefaultValue(int n) {
        return 0.0;
    }

    public String getParameterName(int i) {
        throw new RuntimeException("This model has no parameters!");
    }

    protected AminoAcidModel(double[] f) {
        super(20);
        this.dataType = new AminoAcids();
        this.setFrequencies(f);
    }

    protected void printFrequencies(PrintWriter out) {
        out.println("Amino acid frequencies:");
        super.printFrequencies(out);
    }

    private static double getDist(double[] f1, double[] f2) {
        double sum = 0.0;
        int i = 0;
        while (i < f1.length) {
            double diff = f1[i] - f2[i];
            sum += diff * diff;
            ++i;
        }
        return sum;
    }
}

