/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import pal.datatype.DataType;
import pal.misc.PalObjectListener;
import pal.substmodel.GammaRates;
import pal.substmodel.RateDistribution;
import pal.substmodel.RateMatrix;
import pal.substmodel.SubstitutionModel;
import pal.substmodel.UniformRate;

public class SimpleSubstitutionModel
implements SubstitutionModel {
    private RateMatrix rateMatrix;
    private RateDistribution rateDistribution;
    private int dimension;
    private int numRates;
    private double[][][] probs;
    private int numRmatParams;
    private int numRdistParams;
    private int numParams;
    private static final long serialVersionUID = -4264547361778477341L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.rateMatrix);
        out.writeObject(this.rateDistribution);
        out.writeObject(this.probs);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.rateMatrix = (RateMatrix)in.readObject();
        this.rateDistribution = (RateDistribution)in.readObject();
        this.probs = (double[][][])in.readObject();
        this.dimension = this.rateMatrix.getDimension();
        this.numRates = this.rateDistribution.numRates;
        this.numRmatParams = this.rateMatrix.getNumParameters();
        this.numRdistParams = this.rateDistribution.getNumParameters();
        this.numParams = this.numRmatParams + this.numRdistParams;
    }

    public SimpleSubstitutionModel(RateMatrix rmat) {
        this(rmat, new UniformRate());
    }

    public SimpleSubstitutionModel(RateMatrix rmat, int n, double a) {
        this(rmat, new GammaRates(n, a));
    }

    public SimpleSubstitutionModel(RateMatrix rmat, RateDistribution rdist) {
        this.dimension = rmat.getDimension();
        this.numRates = rdist.numRates;
        this.rateMatrix = rmat;
        this.rateDistribution = rdist;
        this.probs = new double[this.numRates][this.dimension][this.dimension];
        this.numRmatParams = rmat.getNumParameters();
        this.numRdistParams = rdist.getNumParameters();
        this.numParams = this.numRmatParams + this.numRdistParams;
    }

    public DataType getDataType() {
        return this.rateMatrix.getDataType();
    }

    public SimpleSubstitutionModel(SubstitutionModel model) {
        this.dimension = model.getRateMatrix().getDimension();
        this.numRates = model.getRateDistribution().numRates;
        this.numRmatParams = model.getNumParameters();
        this.numRdistParams = model.getRateDistribution().getNumParameters();
        this.rateMatrix = (RateMatrix)model.getRateMatrix().clone();
        this.rateDistribution = (RateDistribution)model.getRateDistribution().clone();
        this.probs = new double[this.numRates][this.dimension][this.dimension];
        this.numParams = this.numRmatParams + this.numRdistParams;
    }

    public void report(PrintWriter out) {
        this.rateMatrix.report(out);
        out.println();
        this.rateDistribution.report(out);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.report(new PrintWriter(sw));
        return sw.toString();
    }

    public int getNumParameters() {
        return this.numParams;
    }

    public void setParameter(double param, int n) {
        if (n < this.numRmatParams) {
            this.rateMatrix.setParameter(param, n);
        } else {
            this.rateDistribution.setParameter(param, n - this.numRmatParams);
        }
    }

    public double getParameter(int n) {
        if (n < this.numRmatParams) {
            return this.rateMatrix.getParameter(n);
        }
        return this.rateDistribution.getParameter(n - this.numRmatParams);
    }

    public void setParameterSE(double paramSE, int n) {
        if (n < this.numRmatParams) {
            this.rateMatrix.setParameterSE(paramSE, n);
        } else {
            this.rateDistribution.setParameterSE(paramSE, n - this.numRmatParams);
        }
    }

    public double getLowerLimit(int n) {
        if (n < this.numRmatParams) {
            return this.rateMatrix.getLowerLimit(n);
        }
        return this.rateDistribution.getLowerLimit(n - this.numRmatParams);
    }

    public double getUpperLimit(int n) {
        if (n < this.numRmatParams) {
            return this.rateMatrix.getUpperLimit(n);
        }
        return this.rateDistribution.getUpperLimit(n - this.numRmatParams);
    }

    public double getDefaultValue(int n) {
        if (n < this.numRmatParams) {
            return this.rateMatrix.getDefaultValue(n);
        }
        return this.rateDistribution.getDefaultValue(n - this.numRmatParams);
    }

    public void setTime(double start, double end) {
        this.setDistance(Math.abs(start - end));
    }

    public void setDistance(double k) {
        int r = 0;
        while (r < this.numRates) {
            double kk = k * this.rateDistribution.rate[r];
            if (kk < 1.0E-9) {
                kk = 1.0E-9;
            }
            if (kk > 100.0) {
                kk = 100.0;
            }
            this.rateMatrix.setDistance(kk);
            this.rateMatrix.getTransitionProbabilities(this.probs[r]);
            ++r;
        }
    }

    public double transProb(int r, int i, int j) {
        return this.probs[r][i][j];
    }

    public boolean isSimpleJukesCantor() {
        if (this.numRates > 1) {
            return false;
        }
        double[] frequencies = this.rateMatrix.getEquilibriumFrequencies();
        double freq = frequencies[0];
        int i = 1;
        while (i < frequencies.length) {
            if (frequencies[i] != freq) {
                return false;
            }
            ++i;
        }
        double[][] relRates = this.rateMatrix.getRelativeRates();
        double rate = relRates[0][1];
        int i2 = 0;
        while (i2 < relRates.length) {
            int j = 0;
            while (j < relRates[i2].length) {
                if (i2 != j && relRates[i2][j] != rate) {
                    return false;
                }
                ++j;
            }
            ++i2;
        }
        return true;
    }

    public Object clone() {
        return new SimpleSubstitutionModel(this);
    }

    public RateMatrix getRateMatrix() {
        return this.rateMatrix;
    }

    public RateDistribution getRateDistribution() {
        return this.rateDistribution;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void addPalObjectListener(PalObjectListener pol) {
        this.rateMatrix.addPalObjectListener(pol);
    }

    public void removePalObjectListener(PalObjectListener pol) {
        this.rateMatrix.removePalObjectListener(pol);
    }

    static {
        serialVersionUID = -4264547361778477341L;
    }
}

