/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.datatype.CodonTable;
import pal.datatype.CodonTableFactory;
import pal.datatype.GeneralizedCodons;
import pal.substmodel.CodonModel;
import pal.util.XMLConstants;

public class YangCodonModel
extends CodonModel
implements Serializable,
XMLConstants {
    private boolean showSE;
    private double kappa;
    private double omega;
    private double kappaSE;
    private double omegaSE;
    private byte[] rateMap;
    private CodonTable codonTable;

    public YangCodonModel(double omega, double kappa, double[] freq, CodonTable codonTable) {
        super(freq);
        this.kappa = kappa;
        this.omega = omega;
        this.codonTable = codonTable;
        this.makeYangModel();
        this.fromQToR();
        this.showSE = false;
    }

    public YangCodonModel(double omega, double kappa, double[] freq) {
        this(omega, kappa, freq, CodonTableFactory.createUniversalTranslator());
    }

    public YangCodonModel(double[] params, double[] freq) {
        this(params[0], params[1], freq, CodonTableFactory.createUniversalTranslator());
    }

    public YangCodonModel(double[] params, double[] freq, CodonTable codonTable) {
        this(params[0], params[1], freq, codonTable);
    }

    public int getModelID() {
        return 0;
    }

    public void report(PrintWriter out) {
        out.println("Model of substitution: YANG (Yang, ????)");
        out.print("Parameter kappa: ");
        this.format.displayDecimal(out, this.kappa, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.kappaSE, 2);
            out.print(")");
        }
        out.println();
        out.print("Parameter omega: ");
        this.format.displayDecimal(out, this.omega, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.omegaSE, 2);
            out.print(")");
        }
        out.println();
        this.printFrequencies(out);
        this.printRatios(out);
    }

    public int getNumParameters() {
        return 2;
    }

    public void setParameter(double param, int n) {
        switch (n) {
            case 0: {
                this.kappa = param;
                break;
            }
            case 1: {
                this.omega = param;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.makeYangModel();
        this.fromQToR();
    }

    public double getParameter(int n) {
        double value;
        switch (n) {
            case 0: {
                value = this.kappa;
                break;
            }
            case 1: {
                value = this.omega;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    public void setParameterSE(double paramSE, int n) {
        switch (n) {
            case 0: {
                this.kappaSE = paramSE;
                break;
            }
            case 1: {
                this.omegaSE = paramSE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.showSE = true;
    }

    public double getLowerLimit(int n) {
        return 1.0E-4;
    }

    public double getUpperLimit(int n) {
        return 100.0;
    }

    public double getDefaultValue(int n) {
        return 1.0;
    }

    public String getParameterName(int i) {
        switch (i) {
            case 0: {
                return "kappa";
            }
            case 1: {
                return "omega";
            }
        }
        return "unknown";
    }

    public String getUniqueName() {
        return "Yang codon model";
    }

    private void makeYangModel() {
        int numRates = this.dimension * (this.dimension - 1) / 2;
        this.rateMap = new byte[numRates];
        GeneralizedCodons generalizedCodons = new GeneralizedCodons();
        int u = 0;
        while (u < this.dimension) {
            char[] codon1 = generalizedCodons.getCodonFromCodonIndex(u);
            int v = u + 1;
            while (v < this.dimension) {
                char[] codon2 = generalizedCodons.getCodonFromCodonIndex(v);
                int rateClass = -1;
                if (codon1[0] != codon2[0]) {
                    rateClass = codon1[0] == 'A' && codon2[0] == 'G' || codon1[0] == 'G' && codon2[0] == 'A' || codon1[0] == 'C' && codon2[0] == 'T' || codon1[0] == 'T' && codon2[0] == 'C' ? 1 : 2;
                }
                if (codon1[1] != codon2[1]) {
                    rateClass = rateClass == -1 ? (codon1[1] == 'A' && codon2[1] == 'G' || codon1[1] == 'G' && codon2[1] == 'A' || codon1[1] == 'C' && codon2[1] == 'T' || codon1[1] == 'T' && codon2[1] == 'C' ? 1 : 2) : 0;
                }
                if (codon1[2] != codon2[2]) {
                    rateClass = rateClass == -1 ? (codon1[2] == 'A' && codon2[2] == 'G' || codon1[2] == 'G' && codon2[2] == 'A' || codon1[2] == 'C' && codon2[2] == 'T' || codon1[2] == 'T' && codon2[2] == 'C' ? 1 : 2) : 0;
                }
                if (rateClass != 0) {
                    char aa1 = this.codonTable.getAminoAcidChar(codon1);
                    char aa2 = this.codonTable.getAminoAcidChar(codon2);
                    if (aa1 == '*' || aa2 == '*') {
                        rateClass = 0;
                    } else if (aa1 != aa2) {
                        rateClass += 2;
                    }
                }
                switch (rateClass) {
                    case 0: {
                        this.rate[u][v] = 0.0;
                        break;
                    }
                    case 1: {
                        this.rate[u][v] = this.kappa;
                        break;
                    }
                    case 2: {
                        this.rate[u][v] = 1.0;
                        break;
                    }
                    case 3: {
                        this.rate[u][v] = this.kappa * this.omega;
                        break;
                    }
                    case 4: {
                        this.rate[u][v] = this.omega;
                    }
                }
                this.rate[v][u] = this.rate[u][v];
                ++v;
            }
            this.rate[u][u] = 0.0;
            ++u;
        }
    }
}

