/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.PrintWriter;
import pal.io.FormattedOutput;
import pal.math.MersenneTwisterFast;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.SimpleNode;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class Local {
    private static MersenneTwisterFast random = new MersenneTwisterFast();
    private static double lambda = 1.0;

    public static Tree local(Tree tree) {
        return Local.local(tree, 1.0);
    }

    public static Tree local(Tree tree, double scaleFactor) {
        if (tree.getRoot().getChildCount() != 3) {
            throw new RuntimeException("Root must have trifurcation!");
        }
        int pos = random.nextInt(tree.getInternalNodeCount() - 1);
        Node node3 = tree.getInternalNode(pos);
        Node node2 = node3.getParent();
        TreeUtils.reroot(tree, node2);
        int k = random.nextInt(node2.getChildCount());
        while (node2.getChild(k) == node3) {
            k = random.nextInt(node2.getChildCount());
        }
        Node node1 = node2.getChild(k);
        Node nodeA = null;
        int i = 0;
        while (i < node2.getChildCount()) {
            if (node2.getChild(i) != node1 && node2.getChild(i) != node3) {
                nodeA = node2.getChild(i);
            }
            ++i;
        }
        Node node4 = node3.getChild(0);
        Node nodeB = node3.getChild(1);
        if (random.nextBoolean()) {
            nodeB = node3.getChild(0);
            node4 = node3.getChild(1);
        }
        double backBoneLength = node1.getBranchLength() + node3.getBranchLength() + node4.getBranchLength();
        double newLength = backBoneLength * scaleFactor;
        node1.setBranchLength(node1.getBranchLength() * scaleFactor);
        node3.setBranchLength(node3.getBranchLength() * scaleFactor);
        node4.setBranchLength(node4.getBranchLength() * scaleFactor);
        double newpos = random.nextDouble() * newLength;
        if (random.nextBoolean()) {
            double easyLength = node1.getBranchLength() + node3.getBranchLength();
            if (newpos < easyLength) {
                node1.setBranchLength(newpos);
                node3.setBranchLength(easyLength - newpos);
            } else {
                Local.swapNodes(nodeA, nodeB);
                node1.setBranchLength(easyLength);
                node3.setBranchLength(newpos - easyLength);
                node4.setBranchLength(newLength - newpos);
            }
        } else {
            double easyLength = node3.getBranchLength() + node4.getBranchLength();
            double hardLength = node1.getBranchLength();
            if (newpos > hardLength) {
                node3.setBranchLength(newpos - hardLength);
                node4.setBranchLength(newLength - newpos);
            } else {
                Local.swapNodes(node1, node4);
                node1.setBranchLength(newpos);
                node3.setBranchLength(hardLength - newpos);
                node4.setBranchLength(easyLength);
            }
        }
        tree.createNodeList();
        NodeUtils.lengths2Heights(tree.getRoot());
        return tree;
    }

    public static Tree stochasticNNI(Tree tree) {
        if (tree.getRoot().getChildCount() != 3) {
            throw new RuntimeException("Root must have trifurcation!");
        }
        int pos = random.nextInt(tree.getInternalNodeCount() - 1);
        Node node3 = tree.getInternalNode(pos);
        Node node2 = node3.getParent();
        TreeUtils.reroot(tree, node2);
        int k = random.nextInt(node2.getChildCount());
        while (node2.getChild(k) == node3) {
            k = random.nextInt(node2.getChildCount());
        }
        Node node1 = node2.getChild(k);
        Node node4 = node3.getChild(0);
        if (random.nextBoolean()) {
            node4 = node3.getChild(1);
        }
        Local.swapNodes(node1, node4);
        return tree;
    }

    private static void swapNodes(Node n1, Node n2) {
        Node parent1 = n1.getParent();
        Node parent2 = n2.getParent();
        int i = 0;
        while (i < parent1.getChildCount()) {
            if (parent1.getChild(i) == n1) {
                parent1.removeChild(i);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < parent2.getChildCount()) {
            if (parent2.getChild(i2) == n2) {
                parent2.removeChild(i2);
            }
            ++i2;
        }
        parent1.addChild(n2);
        parent2.addChild(n1);
    }

    public static void print4TaxonTree(Tree tree, PrintWriter out) {
        FormattedOutput fo = FormattedOutput.getInstance();
        Node root = tree.getRoot();
        Node taxa1 = null;
        Node taxa2 = null;
        Node internal1 = null;
        Node taxa3 = null;
        Node taxa4 = null;
        int i = 0;
        while (i < root.getChildCount()) {
            if (root.getChild(i).isLeaf()) {
                if (taxa1 == null) {
                    taxa1 = root.getChild(i);
                } else {
                    taxa2 = root.getChild(i);
                }
            } else {
                internal1 = root.getChild(i);
            }
            ++i;
        }
        taxa3 = internal1.getChild(0);
        taxa4 = internal1.getChild(1);
        Local.displayLabel(out, taxa1.getIdentifier().getName(), 8, true);
        out.print("               ");
        Local.displayLabel(out, taxa3.getIdentifier().getName(), 8, true);
        out.println();
        out.println("    \\                /");
        out.print("  ");
        fo.displayDecimal(out, taxa1.getBranchLength(), 4);
        out.print("          ");
        fo.displayDecimal(out, taxa3.getBranchLength(), 4);
        out.println();
        out.println("      \\            /");
        Local.displayLabel(out, root.getIdentifier().getName(), 8, false);
        out.print("--");
        fo.displayDecimal(out, internal1.getBranchLength(), 4);
        out.println("--" + internal1.getIdentifier().getName());
        out.println("      /            \\");
        out.print("  ");
        fo.displayDecimal(out, taxa2.getBranchLength(), 4);
        out.print("          ");
        fo.displayDecimal(out, taxa4.getBranchLength(), 4);
        out.println();
        out.println("    /                \\");
        Local.displayLabel(out, taxa2.getIdentifier().getName(), 8, true);
        out.print("               ");
        Local.displayLabel(out, taxa4.getIdentifier().getName(), 8, true);
        out.println();
    }

    public static void displayLabel(PrintWriter out, String label, int width, boolean center) {
        int len = label.length();
        if (len == width) {
            out.print(label);
        } else if (len < width) {
            int first = width - len;
            int second = 0;
            if (center) {
                second = (first /= 2) - (width - len);
            }
            int i = 0;
            while (i < first) {
                out.print(' ');
                ++i;
            }
            out.print(label);
            int i2 = 0;
            while (i2 < second) {
                out.print(' ');
                ++i2;
            }
        } else {
            int i = 0;
            while (i < width) {
                out.print(label.charAt(i));
                ++i;
            }
        }
    }

    public static final void main(String[] args) {
        SimpleNode root = new SimpleNode("I", 0.0);
        SimpleNode node3 = new SimpleNode("I", 0.01);
        SimpleNode node1 = new SimpleNode("1", 0.01);
        SimpleNode nodeA = new SimpleNode("2", 0.01);
        SimpleNode node4 = new SimpleNode("3", 0.01);
        SimpleNode nodeB = new SimpleNode("4", 0.01);
        root.addChild(node1);
        root.addChild(nodeA);
        root.addChild(node3);
        node3.addChild(nodeB);
        node3.addChild(node4);
        SimpleTree tree = new SimpleTree(root);
        SimpleTree tree2 = new SimpleTree(tree);
        SimpleTree tree3 = new SimpleTree(tree);
        PrintWriter pw = new PrintWriter(System.out);
        Local.print4TaxonTree(tree, pw);
        pw.flush();
        System.out.println();
        System.out.println("scaled 0.5");
        Local.print4TaxonTree(Local.local(tree, 0.5), pw);
        pw.flush();
        System.out.println();
        System.out.println("scaled 2.0");
        Local.print4TaxonTree(Local.local(tree2, 2.0), pw);
        pw.flush();
        System.out.println();
        System.out.println("NNI");
        Local.print4TaxonTree(Local.stochasticNNI(tree3), pw);
        pw.flush();
        System.out.println();
    }
}

