/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.distance.DistanceMatrix;
import pal.distance.SUPGMADistanceMatrix;
import pal.misc.TimeOrderCharacterData;
import pal.tree.DatedTipsClockTree;
import pal.tree.Node;
import pal.tree.UPGMATree;

public class SUPGMATree
extends UPGMATree {
    private TimeOrderCharacterData tocd;

    public SUPGMATree(DistanceMatrix m, TimeOrderCharacterData tocd, double rate) {
        this(m, tocd, rate, true);
    }

    public SUPGMATree(DistanceMatrix m, TimeOrderCharacterData tocd, double rate, boolean allowNegatives) {
        super(new SUPGMADistanceMatrix(m, tocd, rate));
        this.tocd = tocd;
        TimeOrderCharacterData idgroup = tocd;
        this.createNodeList();
        Node node = null;
        int i = 0;
        while (i < this.getExternalNodeCount()) {
            node = this.getExternalNode(i);
            int index = idgroup.whichIdNumber(node.getIdentifier().getName());
            node.setNodeHeight(tocd.getHeight(index, rate));
            if (!allowNegatives && node.getParent().getNodeHeight() < node.getNodeHeight()) {
                this.fixHeight(node.getParent(), node.getNodeHeight());
            }
            ++i;
        }
    }

    public DatedTipsClockTree getDatedTipsClockTree() {
        return new DatedTipsClockTree(this, this.tocd, false);
    }

    private void fixHeight(Node node, double height) {
        node.setNodeHeight(height);
        if (!node.isRoot() && node.getParent().getNodeHeight() < height) {
            this.fixHeight(node.getParent(), height);
        }
    }
}

