/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.distance.DistanceMatrix;
import pal.misc.IdGroup;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class TreeDistanceMatrix
extends DistanceMatrix {
    private int[] alias;
    private Tree tree;
    private double[] dist;
    private double[] idist;

    public TreeDistanceMatrix(IdGroup idGroup, Tree t, boolean countEdges, double epsilon) {
        this.numSeqs = idGroup.getIdCount();
        this.idGroup = idGroup;
        this.tree = t;
        this.distance = new double[this.numSeqs][this.numSeqs];
        this.alias = TreeUtils.mapExternalIdentifiers(idGroup, this.tree);
        this.dist = new double[this.tree.getExternalNodeCount()];
        this.idist = new double[this.tree.getInternalNodeCount()];
        this.computeDistances(countEdges, epsilon);
    }

    public TreeDistanceMatrix(IdGroup idGroup, Tree t) {
        this(idGroup, t, false, 0.0);
    }

    public TreeDistanceMatrix(Tree t, boolean countEdges, double epsilon) {
        this(TreeUtils.getLeafIdGroup(t), t, countEdges, epsilon);
    }

    public TreeDistanceMatrix(Tree t) {
        this(t, false, 0.0);
    }

    public void computeDistances() {
        this.computeDistances(false, 0.0);
    }

    public void computeDistances(boolean countEdges, double epsilon) {
        int i = 0;
        while (i < this.tree.getExternalNodeCount()) {
            TreeUtils.computeAllDistances(this.tree, i, this.dist, this.idist, countEdges, epsilon);
            int ai = this.alias[i];
            int j = 0;
            while (j < this.tree.getExternalNodeCount()) {
                this.distance[ai][this.alias[j]] = this.dist[j];
                ++j;
            }
            ++i;
        }
    }
}

