<div align="center">    
 
# Learning Directed Graphs and Root Causes from Time-Series Graph Data

</div>
 
## Description   
This is the implementation of DAG-TFRC: Learning DAGs from Time series with Few Root Causes. 

## Full experiment reproducibility 
Current version of the code was run successfully in Windows 11 with python 3.9.7.


Setup the python environment:
```bash
# create a new conda environment
conda create -n sparserc python=3.9.7
conda activate sparserc

# install all requirements with pip
pip install -r requirements.txt
# javabridge:
conda install -c conda-forge python-javabridge
```

We suggest installation of the following packages using conda.
```bash
# install pydot with conda
conda install pydot
conda install numpy=1.23.4
conda install cvxopt
```

### Other repos
Then manually import the following repositories. 
```bash
# install py-causal repo
pip install git+https://github.com/bd2kccd/py-causal

# clone the following repositories
cd neurips_experiments/methods/
git clone https://github.com/xunzheng/notears
git clone https://github.com/cdt15/lingam
git clone https://github.com/M-Nauta/TCDF
git clone https://github.com/xiangyu-sun-789/NTS-NOTEARS
git clone https://github.com/jakobrunge/tigramite
```

Make sure to have R installed and that the path to the R directory in file **time_series_experiment.py** [`experiments/methods/utils.py`](experiments/methods/utils.py) is correct. Also note the required packages on R for the [causal discovery toolbox](https://fentechsolutions.github.io/CausalDiscoveryToolbox/html/index.html).


## Execution   
To execute the full experiments you may run
```bash
# run all experiments
bash run.sh
# for the plots
bash report.sh
```

In the above shell scripts you may find all the commands to run our experiments.
For a guide of our experimental pipeline and DAG-TFRC execution demonstration you may take a look at A demonstration of our DAG learning method is shown in [`DAG-TFRC_demo.ipynb`](DAG-TFRC_demo.ipynb)