import time
import experiments.utils
import experiments.data.utils
import experiments.methods.utils
from experiments.plot_experiment import visualize, histogram
import pandas as pd
import os
import numpy as np
import experiments.evaluation.utils

def run_real():    
    # make directory to put results
    if not os.path.exists("results/{}/".format(path)):
        os.makedirs("results/{}/".format(path))

    
    for t in [50]:
        # 50 timesteps with l1 = 0.001, omega 0.3, lambda2=1 worked very well for sparserct

        with open('results/{}.csv'.format(path), 'a') as f:

            current = {}
            avgT = {}

            for key in args.methods:
                current[key] = []
                avgT[key] = []

            for r, filename_data in enumerate(os.listdir("experiments/data/FinanceCPT/returns")):
                filename_gt = filename_data.split("_returns")[0] + ".csv"

                # graph initialization
                start = time.time()
                X, _, _, B_true, _ = experiments.data.utils.get_data(args, 0, 0, dataset="finance", filename_data=filename_data, filename_gt=filename_gt)
                print("\n\nData generation process done. Time: {:.3f}\n\n".format(time.time() - start))

                print(B_true.shape)
                # causal discovery algorithms
                for method in args.methods:
                    d = X.shape[-1]
                    # B_est, W_est, T = methods.utils.execute_method(X, method, f, args, pc, dataset="thames")
                    B_est, W_est, T = experiments.methods.utils.execute_method(X, method, args, 0, d, t, dataset="finance", ground_truth=B_true)

                    # save result for future reference
                    df = pd.DataFrame(W_est)
                    df.to_csv('results/{}/W_est_{}_{}.csv'.format(path, method, t), header=None, index=False)

                    experiments.evaluation.utils.compute_metrics(method, current, path, r, t, T, X, None, B_true, 0, B_est, W_est, args)

                    # Create two subplots 
                    visualize(B_true, B_est, method, filename=path+"_{}".format(t)+filename_data, args=args)

            # save average results in csv
            experiments.evaluation.utils.save_results(current, path, args, r=0)

if __name__ == '__main__':
    parser, args = experiments.utils.get_args()
    print(vars(args))

    path = "finance"
    run_real()
