################## Hyperparameter optimization synthetic data
python hyperparameter_search.py --methods dagTFRC sparserc dynotears nts-notears tsfci pcmci TCDF --number_of_lags 2 --samples 1 --timesteps 1000 --nodes 20 --runs 5 --sparsity 0.05 

################### samples 1, length 1000
python time_series_experiment.py --methods dagTFRC sparserc varlingam d_varlingam dynotears nts-notears tsfci pcmci TCDF --number_of_lags 2 --samples 1 --timesteps 1000 --nodes 20 30 50 100  --runs 5 --sparsity 0.05 --timeout 10000 # 5hrs
python time_series_experiment.py --methods dagTFRC sparserc varlingam d_varlingam dynotears TCDF --number_of_lags 2 --samples 1 --timesteps 1000 --nodes 200       --runs 5 --sparsity 0.05 --timeout 10000 #10hrs
python time_series_experiment.py --methods dagTFRC sparserc varlingam dynotears                  --number_of_lags 2 --samples 1 --timesteps 1000 --nodes 500       --runs 5 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC sparserc                             --number_of_lags 2 --samples 1 --timesteps 1000 --nodes 1000       --runs 5 --sparsity 0.05 --timeout 10000

################## samples 10, length 1000
python time_series_experiment.py --methods dagTFRC sparserc varlingam d_varlingam dynotears nts-notears tsfci pcmci TCDF --number_of_lags 2 --samples 10 --timesteps 1000 --nodes 20 30 50 100  --runs 5 --sparsity 0.05 --timeout 10000 # 5hrs
python time_series_experiment.py --methods dagTFRC sparserc varlingam d_varlingam dynotears TCDF --number_of_lags 2 --samples 10 --timesteps 1000 --nodes 200            --runs 5 --sparsity 0.05 --timeout 10000 #10hrs
python time_series_experiment.py --methods dagTFRC sparserc varlingam dynotears TCDF             --number_of_lags 2 --samples 10 --timesteps 1000 --nodes 500 1000       --runs 5 --sparsity 0.05 --timeout 10000 #25hrs
python time_series_experiment.py --methods dagTFRC                                      --number_of_lags 2 --samples 10 --timesteps 1000 --nodes 2000 4000      --runs 5 --sparsity 0.05 --timeout 10000 #2.5hrs

# ################## varying samples
python time_series_experiment.py --methods dagTFRC sparserc varlingam --number_of_lags 2 --samples 1 2 3 5 10 20 --timesteps 1000 --nodes 500  --runs 5 --sparsity 0.05 --timeout 10000 # 5 x 6 x 20mins = 10hrs

############# Checking time-lag effect
################# samples 10, length 1000
python time_series_experiment.py --methods dagTFRC sparserc varlingam   --number_of_lags 3 --algo_lags 3 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 1000  --runs 2 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC sparserc varlingam   --number_of_lags 3 --algo_lags 4 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 1000  --runs 2 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC sparserc varlingam   --number_of_lags 3 --algo_lags 2 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 1000  --runs 2 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC sparserc varlingam   --number_of_lags 3 --algo_lags 1 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 1000  --runs 2 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC sparserc varlingam   --number_of_lags 3 --algo_lags 5 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 1000  --runs 2 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC varlingam            --number_of_lags 3 --algo_lags 6 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 1000  --runs 2 --sparsity 0.05 --timeout 10000 

################################### Large DAGs
python time_series_experiment.py --methods dagTFRC  --number_of_lags 2 --samples 1 2 4 8 16 --timesteps 1000  --nodes 1000 --runs 1  --sparsity 0.05 --timeout 10000 # 5mins
python time_series_experiment.py --methods dagTFRC  --number_of_lags 2 --samples 1 2 4 8 16 --timesteps 1000  --nodes 2000 --runs 1  --sparsity 0.05 --timeout 10000 # 1hrs
python time_series_experiment.py --methods dagTFRC  --number_of_lags 2 --samples 8 16 32 64 --timesteps 1000  --nodes 4000 --runs 1  --sparsity 0.05 --timeout 10000 # 6hrs
python time_series_experiment.py --methods dagTFRC  --number_of_lags 2 --samples 32         --timesteps 1000  --nodes 8000 --runs 1  --sparsity 0.05 --timeout 10000 # timeout

python time_series_experiment.py --methods varlingam  --number_of_lags 2 --samples 8 16             --timesteps 1000  --nodes 1000 --runs 1  --sparsity 0.05 --timeout 10000 # 4hrs
python time_series_experiment.py --methods varlingam  --number_of_lags 2 --samples 1 2 4 8 16 32 64 --timesteps 1000  --nodes 2000 --runs 1  --sparsity 0.05 --timeout 10000 # TIMEOUT everywhere
python time_series_experiment.py --methods varlingam  --number_of_lags 2 --samples 8 16 32 64       --timesteps 1000  --nodes 4000 --runs 1  --sparsity 0.05 --timeout 10000 # TIMEOUT even at 8 so no chance
python time_series_experiment.py --methods varlingam  --number_of_lags 2 --samples 128              --timesteps 1000  --nodes 8000 --runs 1  --sparsity 0.05 --timeout 10000 # Timeout

python time_series_experiment.py --methods sparserc   --number_of_lags 2 --samples 1 2 4 8 16 --timesteps 1000  --nodes 1000 --runs 1  --sparsity 0.05 --timeout 10000 # 5mins
python time_series_experiment.py --methods sparserc   --number_of_lags 2 --samples 1 2 4 8 16 --timesteps 1000  --nodes 2000 --runs 1  --sparsity 0.05 --timeout 10000 # 1hrs

#################################### More lags
python time_series_experiment.py --methods dagTFRC varlingam d_varlingam dynotears nts-notears tsfci pcmci TCDF --number_of_lags 5 --algo_lags 5 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 20 30 50 --runs 5 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC varlingam dynotears d_varlingam TCDF --number_of_lags 5 --algo_lags 5 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 100 200 500 --runs 5 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC varlingam dynotears                  --number_of_lags 5 --algo_lags 5 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 500 --runs 5 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC sparserc                             --number_of_lags 5 --algo_lags 5 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 1000 --runs 5 --sparsity 0.05 --timeout 10000
python time_series_experiment.py --methods dagTFRC                                      --number_of_lags 5 --algo_lags 5 --weight_bounds 0.1 0.2 --samples 10 --timesteps 1000 --nodes 2000 --runs 5 --sparsity 0.05 --timeout 10000

#################################--------------Simulated-------------------------_###################################
python hyperparameter_finance.py --methods dagTFRC sparserc varlingam d_varlingam dynotears nts-notears tsfci pcmci TCDF --number_of_lags 3 --algo_lags 3 

python finance.py --methods dagTFRC sparserc varlingam d_varlingam dynotears nts-notears tsfci pcmci TCDF --number_of_lags 3 --algo_lags 3 

#################################--------------Real data-------------------------_###################################
############# DREAM3 challenge dataset
python dream3.py --methods d_varlingam  --number_of_lags 0 --algo_lags 0 --runs 1 --lambda1 0.05 --lambda2 10 --timeout 10000
python dream3.py --methods nts-notears tsfci --number_of_lags 0 --algo_lags 0 --runs 1 --lambda1 0.05 --lambda2 10 --timeout 10000
python dream3.py --methods dynotears --number_of_lags 0 --algo_lags 0 --runs 1 --lambda1 0.05 --lambda2 10 --timeout 10000
python dream3.py --methods TCDF --number_of_lags 0 --algo_lags 0 --runs 1 --lambda1 0.05 --lambda2 10 --timeout 10000


