# DISCoVeR
 DISCoVeR, is a novel variational framework that explicitly separates condition-invariant and condition-specific factors. DISCoVeR integrates three key components:
  1.  A dual-latent architecture that models shared and specific factors separately
  2.  Two parallel reconstructions that ensure both representations remain informative  
  3. A novel max-min objective that encourages clean separation without relying on handcrafted priors, while making only minimal assumptions.


![model_fig](./assets/model.jpg)

# Technical Details & Repository Structure
This repository offers implementations for DISCoVeR and all other compared models for multi-condition (and even multi-label) settings. All models are implemented through [PyTorch](https://pytorch.org/) and specifically using the [Pyro](https://pyro.ai/) framework.

The folder `src/` includes all requirements for current and future applications of all models compared in the study to generic datasets (`VAE_variants.py`), vision datasets (`CNN_variants.py`) and single-cell RNA-sequencing data (`NBVAE_variants.py`). Other files include shared capabilities (`VAE_mixins.py`), model trainers (`VAE_trainers.py`) and metrics (`metrics.py`).

In the root directory (`./`), we offer notebooks intended to both act as applied tutorials and offer reproducibility for a single experiment on the designated dataset.

If you use any of the models for single-cell, make sure to cite the original [scVI](https://www.nature.com/articles/s41592-018-0229-2) implementation, as our implementations mimic their generative model.


# Disclaimer
The material in this repository is offered as-is, without any warranties. While being flexible for independent applications in its current state, the full code will eventually be integrated into a package and the documentation will be considerably improved. A support contact will be provided upon release of the package.
