#!/bin/bash

# Pass DATASET and ARCH as env vars.
#
# Usage:
# DATASET=cifar10 ARCH=vgg11 bash slurm/launch_sweep.sh
# DATASET=cifar100 ARCH=resnet_v1_18 bash slurm/launch_sweep.sh

set -eu

SCRIPT=slurm/run_cifar_sweep.sh

SCHEDULE=piece
LOSS=ce

SHARED_ARGS="--dataset=$DATASET --model.arch=$ARCH --train.loss=$LOSS --train.schedule=$SCHEDULE"

set -x

for seed in {0..4} ; do
	NAME="$DATASET-$ARCH-$LOSS-$seed"
	#sbatch -J "baseline-$NAME" $SCRIPT $SHARED_ARGS --seed=$seed
	for wd in 1e-5 2e-5 5e-5 1e-4 2e-4 5e-4 1e-3 2e-3 5e-3 1e-2 ; do
		sbatch -J "wd-$NAME" $SCRIPT $SHARED_ARGS --seed=$seed --train.weight_decay=$wd
	done
done
