#!/bin/bash

# Pass DATASET and ARCH as env vars.
#
# Usage:
# DATASET=cifar10 ARCH=vgg11 bash slurm/launch_wd_sweep.sh
# DATASET=cifar100 ARCH=resnet_v1_18 bash slurm/launch_wd_sweep.sh

set -eu

SCRIPT=slurm/run_cifar_sweep.sh

SCHEDULE=piece
LOSS=ce
WD=5e-4

SHARED_ARGS="--dataset=$DATASET --model.arch=$ARCH --train.loss=$LOSS --train.schedule=$SCHEDULE --train.weight_decay=$WD"

set -x

for seed in {0..4} ; do
	NAME="wd-$DATASET-$ARCH-$LOSS-$seed"
	sbatch -J "baseline-$NAME" $SCRIPT $SHARED_ARGS --seed=$seed
	for beta in 0.1 0.2 0.5 1 2 ; do
		sbatch -J "mix-$NAME" $SCRIPT $SHARED_ARGS --seed=$seed --train.mixup_beta=$beta
	done
	for smooth in 0.01 0.05 0.1 0.2 0.5 0.8 ; do
		sbatch -J "ls-$NAME" $SCRIPT $SHARED_ARGS --seed=$seed --train.ce_smooth=$smooth
	done
	for prob in 0.1 0.25 0.5 0.75 1 ; do
		sbatch -J "aug-$NAME" $SCRIPT $SHARED_ARGS --seed=$seed --train.aug_prob=$prob
	done
	for rho in 0.01 0.02 0.05 0.1 0.2 ; do
		sbatch -J "sam-$NAME" $SCRIPT $SHARED_ARGS --seed=$seed --train.sam_rho=$rho
	done
done
