import contextlib
import datetime
import sys
import time


@contextlib.contextmanager
def timer(desc):
    start = time.time()
    try:
        yield start
    finally:
        dur = datetime.timedelta(seconds=time.time() - start)
        print(f'{desc}: {dur!s}', file=sys.stderr)
