
#####################################################################################
## This script loads the outputs generated by the jupyter notebooks
## "miav_jf_fc_on_baseline_data.ipynb" and
## "noisy_miav_for_baseline_comparisons.ipynb"
## and evaluates the synthetic data w.r.t. fidelity and privacy metrics.
#####################################################################################

# source utility functions
source("utility_functions_for_miav_tabpfn_iclr.R")

library(arrow)

# path to the folders storing the saved outputs
data_path <- ""
noisy_data_path <- ""

# list generators names
generator_names <- c("miav", 
                     "jf", 
                     "fc", 
                     "arf", 
                     "ctgan", 
                     "tvae", 
                     "ddpm", 
                     "bayesnet", 
                     "smote")
noisy_generator_names <- c("noisy_miav_0.05", 
                           "noisy_miav_0.1", 
                           "noisy_miav_0.15", 
                           "noisy_miav_0.2", 
                           "noisy_miav_0.25", 
                           "noisy_miav_0.3")


## evaluate all generators w.r.t the fidelity and privacy metrics on the AB data
set.seed(12345)
out_AB <- RunEvaluationsBaseline(ds_name = "abalone",
                         data_path = data_path,
                         generator_names = generator_names,
                         noisy_data_path = noisy_data_path,
                         noisy_generator_names = noisy_generator_names,
                         n_runs = 5)


## evaluate all generators w.r.t the fidelity and privacy metrics on the BM data
set.seed(12345)
out_BM <- RunEvaluationsBaseline(ds_name = "bank",
                         data_path = data_path,
                         generator_names = generator_names,
                         noisy_data_path = noisy_data_path,
                         noisy_generator_names = noisy_generator_names,
                         n_runs = 5)


## evaluate all generators w.r.t the fidelity and privacy metrics on the CR data
set.seed(12345)
out_CR <- RunEvaluationsBaseline(ds_name = "credit",
                         data_path = data_path,
                         generator_names = generator_names,
                         noisy_data_path = noisy_data_path,
                         noisy_generator_names = noisy_generator_names,
                         n_runs = 5)


## evaluate all generators w.r.t the fidelity and privacy metrics on the EM data
set.seed(12345)
out_EM <- RunEvaluationsBaseline(ds_name = "eye",
                         data_path = data_path,
                         generator_names = generator_names,
                         noisy_data_path = noisy_data_path,
                         noisy_generator_names = noisy_generator_names,
                         n_runs = 5)


## evaluate all generators w.r.t the fidelity and privacy metrics on the HO data
set.seed(12345)
out_HO <- RunEvaluationsBaseline(ds_name = "house16h",
                         data_path = data_path,
                         generator_names = generator_names,
                         noisy_data_path = noisy_data_path,
                         noisy_generator_names = noisy_generator_names,
                         n_runs = 5)


## evaluate all generators w.r.t the fidelity and privacy metrics on the MT data
set.seed(12345)
out_MT <- RunEvaluationsBaseline(ds_name = "magic",
                         data_path = data_path,
                         generator_names = generator_names,
                         noisy_data_path = noisy_data_path,
                         noisy_generator_names = noisy_generator_names,
                         n_runs = 5)


## evaluate all generators w.r.t the fidelity and privacy metrics on the PO data
set.seed(12345)
out_PO <- RunEvaluationsBaseline(ds_name = "pol",
                         data_path = data_path,
                         generator_names = generator_names,
                         noisy_data_path = noisy_data_path,
                         noisy_generator_names = noisy_generator_names,
                         n_runs = 5)


save(out_AB, out_BM, out_CR, out_EM, out_HO, out_MT, out_PO, 
     file = "outputs_real_world_experiments_baseline_comparisons.RData", 
     compress = TRUE)


