## Readme for ICLR submission

## Download data
The dataset to compare adversarial attacks is at: [PerC](https://github.com/ZhengyuZhao/PerC-Adversarial). Download the images and put in /dataset.
Our Imagenet geo-location dataset is available: [Google Drive](https://drive.google.com/file/d/1usMk7fncPWqLZ0CAmnQnwrtchbgzp5wB/view?usp=sharing)

## Download pretrained models from other repos

 - Download EGNet's model weights from this link [EGNet](https://drive.google.com/file/d/1q7FtHWoarRzGNQQXTn9t7QSR8jJL8vk6/view) and put in /EGNET
- Download PieAPP's model and put in /PerceptualImageError/weights:
```
bash PerceptualImageError/scripts/download_PieAPPv0.1_PT_weights.sh
```

## Reproduce the results in the paper
### Generate attacks
 - Our method
 ```
 python3 attack_main.py
 ```
 - PGD method
 ```
 python3 PGD_main.py
 ```
- PerC method
 ```
 python3 perc_main.py
 ```
- NPTM methods (need change the method between LPA and PPGD)
```
python3 perceptual_main.py
```
### Figure 5 and Table 1:
- success rates: run `test_success_rate.ipynb`.
- distance comparison results: run `compare.ipynb`.
### Figure 6 and Table 2:  
Run `human_saliency.ipynb`
### Generate Kmeans clustering on all images (speed up the training, optional):
```
python3 kmeans_imagenet.py
```
### DRO training: if not using Kmeans to speed up, follow the comments (at line 85 and 239) to change codes
```
python3 lttrain_imagenet.py
```
### test fairness: run `test_fairness.ipynb`
